/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpTimeoutException;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.amqp.rabbit.connection.ChannelProxy;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.connection.ConnectionProxy;
import org.springframework.amqp.rabbit.connection.PublisherCallbackChannelConnectionFactory;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.support.PublisherCallbackChannel;
import org.springframework.amqp.rabbit.support.PublisherCallbackChannelImpl;
import org.springframework.amqp.support.ConditionalExceptionLogger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class CachingConnectionFactory
extends AbstractConnectionFactory
implements InitializingBean,
ShutdownListener,
ApplicationContextAware,
ApplicationListener<ContextClosedEvent>,
PublisherCallbackChannelConnectionFactory,
SmartLifecycle {
    private final ChannelCachingConnectionProxy connection = new ChannelCachingConnectionProxy(null);
    private ApplicationContext applicationContext;
    private final Set<ChannelCachingConnectionProxy> allocatedConnections = new HashSet<ChannelCachingConnectionProxy>();
    private final Map<ChannelCachingConnectionProxy, LinkedList<ChannelProxy>> allocatedConnectionNonTransactionalChannels = new HashMap<ChannelCachingConnectionProxy, LinkedList<ChannelProxy>>();
    private final Map<ChannelCachingConnectionProxy, LinkedList<ChannelProxy>> allocatedConnectionTransactionalChannels = new HashMap<ChannelCachingConnectionProxy, LinkedList<ChannelProxy>>();
    private final BlockingDeque<ChannelCachingConnectionProxy> idleConnections = new LinkedBlockingDeque<ChannelCachingConnectionProxy>();
    private final Map<Connection, Semaphore> checkoutPermits = new HashMap<Connection, Semaphore>();
    private volatile long channelCheckoutTimeout = 0L;
    private volatile CacheMode cacheMode = CacheMode.CHANNEL;
    private volatile int channelCacheSize = 1;
    private volatile int connectionCacheSize = 1;
    private volatile int connectionLimit = Integer.MAX_VALUE;
    private final LinkedList<ChannelProxy> cachedChannelsNonTransactional = new LinkedList();
    private final LinkedList<ChannelProxy> cachedChannelsTransactional = new LinkedList();
    private volatile boolean active = true;
    private volatile boolean publisherConfirms;
    private volatile boolean publisherReturns;
    private volatile boolean initialized;
    private volatile boolean contextStopped;
    private volatile boolean stopped;
    private volatile boolean running;
    private int phase = -2147482648;
    private volatile ConditionalExceptionLogger closeExceptionLogger = new DefaultChannelCloseLogger();
    private final Object connectionMonitor = new Object();
    private final ExecutorService deferredCloseExecutor = Executors.newCachedThreadPool();

    public CachingConnectionFactory() {
        this((String)null);
    }

    public CachingConnectionFactory(String hostname, int port) {
        super(new ConnectionFactory());
        if (!StringUtils.hasText((String)hostname)) {
            hostname = this.getDefaultHostName();
        }
        this.setHost(hostname);
        this.setPort(port);
    }

    public CachingConnectionFactory(URI uri) {
        super(new ConnectionFactory());
        this.setUri(uri);
    }

    public CachingConnectionFactory(int port) {
        this(null, port);
    }

    public CachingConnectionFactory(String hostname) {
        this(hostname, 5672);
    }

    public CachingConnectionFactory(ConnectionFactory rabbitConnectionFactory) {
        super(rabbitConnectionFactory);
    }

    public void setChannelCacheSize(int sessionCacheSize) {
        Assert.isTrue((sessionCacheSize >= 1 ? 1 : 0) != 0, (String)"Channel cache size must be 1 or higher");
        this.channelCacheSize = sessionCacheSize;
    }

    public int getChannelCacheSize() {
        return this.channelCacheSize;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode cacheMode) {
        Assert.isTrue((!this.initialized ? 1 : 0) != 0, (String)"'cacheMode' cannot be changed after initialization.");
        Assert.notNull((Object)((Object)cacheMode), (String)"'cacheMode' must not be null.");
        this.cacheMode = cacheMode;
    }

    @Deprecated
    public int getConnectionCachesize() {
        return this.getConnectionCacheSize();
    }

    public int getConnectionCacheSize() {
        return this.connectionCacheSize;
    }

    public void setConnectionCacheSize(int connectionCacheSize) {
        Assert.isTrue((connectionCacheSize >= 1 ? 1 : 0) != 0, (String)"Connection cache size must be 1 or higher.");
        this.connectionCacheSize = connectionCacheSize;
    }

    public void setConnectionLimit(int connectionLimit) {
        Assert.isTrue((connectionLimit >= 1 ? 1 : 0) != 0, (String)"Connection limit must be 1 or higher.");
        this.connectionLimit = connectionLimit;
    }

    @Override
    public boolean isPublisherConfirms() {
        return this.publisherConfirms;
    }

    @Override
    public boolean isPublisherReturns() {
        return this.publisherReturns;
    }

    public void setPublisherReturns(boolean publisherReturns) {
        this.publisherReturns = publisherReturns;
    }

    public void setPublisherConfirms(boolean publisherConfirms) {
        this.publisherConfirms = publisherConfirms;
    }

    public void setChannelCheckoutTimeout(long channelCheckoutTimeout) {
        this.channelCheckoutTimeout = channelCheckoutTimeout;
    }

    public void setCloseExceptionLogger(ConditionalExceptionLogger closeExceptionLogger) {
        Assert.notNull((Object)closeExceptionLogger, (String)"'closeExceptionLogger' cannot be null");
        this.closeExceptionLogger = closeExceptionLogger;
    }

    public void afterPropertiesSet() throws Exception {
        this.initialized = true;
        if (this.cacheMode == CacheMode.CHANNEL) {
            Assert.isTrue((this.connectionCacheSize == 1 ? 1 : 0) != 0, (String)"When the cache mode is 'CHANNEL', the connection cache size cannot be configured.");
        }
    }

    @Override
    public void setConnectionListeners(List<? extends ConnectionListener> listeners) {
        super.setConnectionListeners(listeners);
        if (this.connection.target != null) {
            this.getConnectionListener().onCreate(this.connection);
        }
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        super.addConnectionListener(listener);
        if (this.connection.target != null) {
            listener.onCreate(this.connection);
        }
    }

    public void shutdownCompleted(ShutdownSignalException cause) {
        this.closeExceptionLogger.log(this.logger, "Channel shutdown", (Throwable)cause);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        if (this.applicationContext == event.getApplicationContext()) {
            this.contextStopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Channel getChannel(ChannelCachingConnectionProxy connection, boolean transactional) {
        LinkedList<ChannelProxy> channelList;
        if (this.channelCheckoutTimeout > 0L) {
            Semaphore checkoutPermits = this.checkoutPermits.get(connection);
            if (checkoutPermits == null) throw new IllegalStateException("No permits map entry for " + connection);
            try {
                if (!checkoutPermits.tryAcquire(this.channelCheckoutTimeout, TimeUnit.MILLISECONDS)) {
                    throw new AmqpTimeoutException("No available channels");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Acquired permit for " + connection + ", remaining:" + checkoutPermits.availablePermits()));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new AmqpTimeoutException("Interrupted while acquiring a channel", (Throwable)e);
            }
        }
        if (this.cacheMode == CacheMode.CHANNEL) {
            channelList = transactional ? this.cachedChannelsTransactional : this.cachedChannelsNonTransactional;
        } else {
            LinkedList<ChannelProxy> linkedList = channelList = transactional ? this.allocatedConnectionTransactionalChannels.get(connection) : this.allocatedConnectionNonTransactionalChannels.get(connection);
        }
        if (channelList == null) {
            throw new IllegalStateException("No channel list for connection " + connection);
        }
        ChannelProxy channel = null;
        if (connection.isOpen()) {
            LinkedList<ChannelProxy> linkedList = channelList;
            synchronized (linkedList) {
                while (!channelList.isEmpty()) {
                    block22: {
                        channel = channelList.removeFirst();
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace((Object)(channel + " retrieved from cache"));
                        }
                        if (channel.isOpen()) break;
                        try {
                            Channel target = channel.getTargetChannel();
                            if (target != null) {
                                target.close();
                            }
                        }
                        catch (AlreadyClosedException e) {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace((Object)(channel + " is already closed"));
                            }
                        }
                        catch (IOException e) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Unexpected Exception closing channel " + e.getMessage()));
                            }
                        }
                        catch (TimeoutException e) {
                            if (!this.logger.isWarnEnabled()) break block22;
                            this.logger.warn((Object)("TimeoutException closing channel " + e.getMessage()));
                        }
                    }
                    channel = null;
                }
            }
            if (channel != null && this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Found cached Rabbit Channel: " + channel.toString()));
            }
        }
        if (channel != null) return channel;
        return this.getCachedChannelProxy(connection, channelList, transactional);
    }

    private ChannelProxy getCachedChannelProxy(ChannelCachingConnectionProxy connection, LinkedList<ChannelProxy> channelList, boolean transactional) {
        Channel targetChannel = this.createBareChannel(connection, transactional);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating cached Rabbit Channel from " + targetChannel));
        }
        this.getChannelListener().onCreate(targetChannel, transactional);
        Class[] interfaces = this.publisherConfirms || this.publisherReturns ? new Class[]{ChannelProxy.class, PublisherCallbackChannel.class} : new Class[]{ChannelProxy.class};
        return (ChannelProxy)Proxy.newProxyInstance(ChannelProxy.class.getClassLoader(), interfaces, (InvocationHandler)new CachedChannelInvocationHandler(connection, targetChannel, channelList, transactional));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel createBareChannel(ChannelCachingConnectionProxy connection, boolean transactional) {
        if (this.cacheMode == CacheMode.CHANNEL) {
            if (!this.connection.isOpen()) {
                Object object = this.connectionMonitor;
                synchronized (object) {
                    if (!this.connection.isOpen()) {
                        this.connection.notifyCloseIfNecessary();
                    }
                    if (!this.connection.isOpen()) {
                        this.connection.target = null;
                        this.createConnection();
                    }
                }
            }
            return this.doCreateBareChannel(this.connection, transactional);
        }
        if (this.cacheMode == CacheMode.CONNECTION) {
            if (!connection.isOpen()) {
                Object object = this.connectionMonitor;
                synchronized (object) {
                    this.allocatedConnectionNonTransactionalChannels.get(connection).clear();
                    this.allocatedConnectionTransactionalChannels.get(connection).clear();
                    connection.notifyCloseIfNecessary();
                    this.refreshProxyConnection(connection);
                }
            }
            return this.doCreateBareChannel(connection, transactional);
        }
        return null;
    }

    private Channel doCreateBareChannel(ChannelCachingConnectionProxy connection, boolean transactional) {
        Channel channel = connection.createBareChannel(transactional);
        if (this.publisherConfirms) {
            try {
                channel.confirmSelect();
            }
            catch (IOException e) {
                this.logger.error((Object)"Could not configure the channel to receive publisher confirms", (Throwable)e);
            }
        }
        if ((this.publisherConfirms || this.publisherReturns) && !(channel instanceof PublisherCallbackChannelImpl)) {
            channel = new PublisherCallbackChannelImpl(channel);
        }
        if (channel != null) {
            channel.addShutdownListener((ShutdownListener)this);
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Connection createConnection() throws AmqpException {
        Assert.state((!this.stopped ? 1 : 0) != 0, (String)"The ApplicationContext is closed and the ConnectionFactory can no longer create connections.");
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.cacheMode == CacheMode.CHANNEL) {
                if (this.connection.target == null) {
                    this.connection.target = super.createBareConnection();
                    if (!this.checkoutPermits.containsKey(this.connection)) {
                        this.checkoutPermits.put(this.connection, new Semaphore(this.channelCacheSize));
                    }
                    this.getConnectionListener().onCreate(this.connection);
                }
                return this.connection;
            }
            if (this.cacheMode == CacheMode.CONNECTION) {
                ChannelCachingConnectionProxy connection = this.findIdleConnection();
                long now = System.currentTimeMillis();
                while (connection == null && System.currentTimeMillis() - now < this.channelCheckoutTimeout) {
                    if (this.countOpenConnections() < this.connectionLimit) continue;
                    try {
                        this.connectionMonitor.wait(this.channelCheckoutTimeout);
                        connection = this.findIdleConnection();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new AmqpException("Interrupted while waiting for a connection", (Throwable)e);
                    }
                }
                if (connection == null) {
                    if (this.countOpenConnections() >= this.connectionLimit && System.currentTimeMillis() - now >= this.channelCheckoutTimeout) {
                        throw new AmqpTimeoutException("Timed out attempting to get a connection");
                    }
                    connection = new ChannelCachingConnectionProxy(super.createBareConnection());
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Adding new connection '" + connection + "'"));
                    }
                    this.allocatedConnections.add(connection);
                    this.allocatedConnectionNonTransactionalChannels.put(connection, new LinkedList());
                    this.allocatedConnectionTransactionalChannels.put(connection, new LinkedList());
                    this.checkoutPermits.put(connection, new Semaphore(this.channelCacheSize));
                    this.getConnectionListener().onCreate(connection);
                } else if (!connection.isOpen()) {
                    try {
                        this.refreshProxyConnection(connection);
                    }
                    catch (Exception e) {
                        this.idleConnections.addLast(connection);
                    }
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Obtained connection '" + connection + "' from cache"));
                }
                return connection;
            }
        }
        return null;
    }

    private ChannelCachingConnectionProxy findIdleConnection() {
        ChannelCachingConnectionProxy connection = null;
        ChannelCachingConnectionProxy lastIdle = (ChannelCachingConnectionProxy)this.idleConnections.peekLast();
        while (connection == null && (connection = this.idleConnections.poll()) != null) {
            if (connection.isOpen()) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Skipping closed connection '" + connection + "'"));
            }
            connection.notifyCloseIfNecessary();
            this.idleConnections.addLast(connection);
            if (connection.equals(lastIdle)) {
                connection = this.idleConnections.poll();
                break;
            }
            connection = null;
        }
        return connection;
    }

    private void refreshProxyConnection(ChannelCachingConnectionProxy connection) {
        connection.destroy();
        connection.notifyCloseIfNecessary();
        connection.target = super.createBareConnection();
        connection.closeNotified.set(false);
        this.getConnectionListener().onCreate(connection);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Refreshed existing connection '" + connection + "'"));
        }
    }

    @Override
    public final void destroy() {
        this.resetConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection.target != null) {
                this.connection.destroy();
            }
            for (ChannelCachingConnectionProxy connection : this.allocatedConnections) {
                connection.destroy();
            }
        }
    }

    public void start() {
        this.running = true;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop() {
        if (this.contextStopped) {
            this.running = false;
            this.stopped = true;
            this.deferredCloseExecutor.shutdownNow();
        } else {
            this.logger.warn((Object)"stop() is ignored unless the application context is being stopped");
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset(List<ChannelProxy> channels, List<ChannelProxy> txChannels) {
        this.active = false;
        List<ChannelProxy> list = channels;
        synchronized (list) {
            for (ChannelProxy channel : channels) {
                try {
                    channel.close();
                }
                catch (Exception ex) {
                    this.logger.trace((Object)"Could not close cached Rabbit Channel", (Throwable)ex);
                }
            }
            channels.clear();
        }
        list = txChannels;
        synchronized (list) {
            for (ChannelProxy channel : txChannels) {
                try {
                    channel.close();
                }
                catch (Exception ex) {
                    this.logger.trace((Object)"Could not close cached Rabbit Channel", (Throwable)ex);
                }
            }
            txChannels.clear();
        }
        this.active = true;
    }

    private int countOpenConnections() {
        int n = 0;
        for (ChannelCachingConnectionProxy proxy : this.allocatedConnections) {
            if (!proxy.isOpen()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public String toString() {
        return "CachingConnectionFactory [channelCacheSize=" + this.channelCacheSize + ", host=" + this.getHost() + ", port=" + this.getPort() + ", active=" + this.active + " " + super.toString() + "]";
    }

    private static class DefaultChannelCloseLogger
    implements ConditionalExceptionLogger {
        private DefaultChannelCloseLogger() {
        }

        public void log(Log logger, String message, Throwable t) {
            if (t instanceof ShutdownSignalException) {
                ShutdownSignalException cause = (ShutdownSignalException)t;
                if (RabbitUtils.isPassiveDeclarationChannelClose(cause)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(message + ": " + cause.getMessage()));
                    }
                } else if (RabbitUtils.isExclusiveUseChannelClose(cause)) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)(message + ": " + cause.getMessage()));
                    }
                } else if (!RabbitUtils.isNormalChannelClose(cause)) {
                    logger.error((Object)(message + ": " + cause.getMessage()));
                }
            } else {
                logger.error((Object)("Unexpected invocation of " + this.getClass() + ", with message: " + message), t);
            }
        }
    }

    private class ChannelCachingConnectionProxy
    implements Connection,
    ConnectionProxy {
        private volatile Connection target;
        private final AtomicBoolean closeNotified = new AtomicBoolean(false);

        private ChannelCachingConnectionProxy(Connection target) {
            this.target = target;
        }

        private Channel createBareChannel(boolean transactional) {
            return this.target.createChannel(transactional);
        }

        @Override
        public Channel createChannel(boolean transactional) {
            return CachingConnectionFactory.this.getChannel(this, transactional);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (CachingConnectionFactory.this.cacheMode == CacheMode.CONNECTION) {
                Object object = CachingConnectionFactory.this.connectionMonitor;
                synchronized (object) {
                    if (!CachingConnectionFactory.this.idleConnections.contains(this)) {
                        if (!this.target.isOpen() || this.countOpenIdleConnections() >= CachingConnectionFactory.this.connectionCacheSize) {
                            if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                                CachingConnectionFactory.this.logger.debug((Object)("Completely closing connection '" + this + "'"));
                            }
                            this.destroy();
                        }
                        if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                            CachingConnectionFactory.this.logger.debug((Object)("Returning connection '" + this + "' to cache"));
                        }
                        CachingConnectionFactory.this.idleConnections.add(this);
                        CachingConnectionFactory.this.connectionMonitor.notifyAll();
                    }
                }
            }
        }

        private int countOpenIdleConnections() {
            int n = 0;
            for (ChannelCachingConnectionProxy proxy : CachingConnectionFactory.this.idleConnections) {
                if (!proxy.isOpen()) continue;
                ++n;
            }
            return n;
        }

        public void destroy() {
            if (CachingConnectionFactory.this.cacheMode == CacheMode.CHANNEL) {
                CachingConnectionFactory.this.reset(CachingConnectionFactory.this.cachedChannelsNonTransactional, CachingConnectionFactory.this.cachedChannelsTransactional);
            } else {
                CachingConnectionFactory.this.reset((List)CachingConnectionFactory.this.allocatedConnectionNonTransactionalChannels.get(this), (List)CachingConnectionFactory.this.allocatedConnectionTransactionalChannels.get(this));
            }
            if (this.target != null) {
                RabbitUtils.closeConnection(this.target);
                this.notifyCloseIfNecessary();
            }
            this.target = null;
        }

        private void notifyCloseIfNecessary() {
            if (!this.closeNotified.getAndSet(true)) {
                CachingConnectionFactory.this.getConnectionListener().onClose(this);
            }
        }

        @Override
        public boolean isOpen() {
            return this.target != null && this.target.isOpen();
        }

        @Override
        public Connection getTargetConnection() {
            return this.target;
        }

        public String toString() {
            return "Proxy@" + ObjectUtils.getIdentityHexString((Object)this) + " " + (CachingConnectionFactory.this.cacheMode == CacheMode.CHANNEL ? "Shared " : "Dedicated ") + "Rabbit Connection: " + this.target;
        }
    }

    private class CachedChannelInvocationHandler
    implements InvocationHandler {
        private final ChannelCachingConnectionProxy theConnection;
        private volatile Channel target;
        private final LinkedList<ChannelProxy> channelList;
        private final Object targetMonitor = new Object();
        private final boolean transactional;

        private CachedChannelInvocationHandler(ChannelCachingConnectionProxy connection, Channel target, LinkedList<ChannelProxy> channelList, boolean transactional) {
            this.theConnection = connection;
            this.target = target;
            this.channelList = channelList;
            this.transactional = transactional;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("txSelect") && !this.transactional) {
                throw new UnsupportedOperationException("Cannot start transaction on non-transactional channel");
            }
            if (methodName.equals("equals")) {
                return proxy == args[0];
            }
            if (methodName.equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (methodName.equals("toString")) {
                return "Cached Rabbit Channel: " + this.target + ", conn: " + this.theConnection;
            }
            if (methodName.equals("close")) {
                if (CachingConnectionFactory.this.active) {
                    LinkedList<ChannelProxy> linkedList = this.channelList;
                    synchronized (linkedList) {
                        if (!RabbitUtils.isPhysicalCloseRequired() && (this.channelList.size() < CachingConnectionFactory.this.getChannelCacheSize() || this.channelList.contains(proxy))) {
                            this.releasePermitIfNecessary(proxy);
                            this.logicalClose((ChannelProxy)proxy);
                            return null;
                        }
                    }
                }
                this.physicalClose();
                this.releasePermitIfNecessary(proxy);
                return null;
            }
            if (methodName.equals("getTargetChannel")) {
                return this.target;
            }
            if (methodName.equals("isOpen")) {
                return this.target != null && this.target.isOpen();
            }
            if (methodName.equals("isTransactional")) {
                return this.transactional;
            }
            try {
                if (this.target == null || !this.target.isOpen()) {
                    if (this.target instanceof PublisherCallbackChannel) {
                        this.target.close();
                        throw new InvocationTargetException(new AmqpException("PublisherCallbackChannel is closed"));
                    }
                    this.target = null;
                }
                Object object = this.targetMonitor;
                synchronized (object) {
                    if (this.target == null) {
                        this.target = CachingConnectionFactory.this.createBareChannel(this.theConnection, this.transactional);
                    }
                    return method.invoke((Object)this.target, args);
                }
            }
            catch (InvocationTargetException ex) {
                if (this.target == null || !this.target.isOpen()) {
                    if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                        CachingConnectionFactory.this.logger.debug((Object)("Detected closed channel on exception.  Re-initializing: " + this.target));
                    }
                    this.target = null;
                    Object object = this.targetMonitor;
                    synchronized (object) {
                        if (this.target == null) {
                            this.target = CachingConnectionFactory.this.createBareChannel(this.theConnection, this.transactional);
                        }
                    }
                }
                throw ex.getTargetException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releasePermitIfNecessary(Object proxy) {
            if (CachingConnectionFactory.this.channelCheckoutTimeout > 0L) {
                LinkedList<ChannelProxy> linkedList = this.channelList;
                synchronized (linkedList) {
                    if (this.channelList.contains(proxy)) {
                        return;
                    }
                }
                Semaphore checkoutPermits = (Semaphore)CachingConnectionFactory.this.checkoutPermits.get(this.theConnection);
                if (checkoutPermits != null) {
                    checkoutPermits.release();
                    if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                        CachingConnectionFactory.this.logger.debug((Object)("Released permit for " + this.theConnection + ", remaining:" + checkoutPermits.availablePermits()));
                    }
                } else {
                    CachingConnectionFactory.this.logger.error((Object)("LEAKAGE: No permits map entry for " + this.theConnection));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logicalClose(ChannelProxy proxy) throws Exception {
            if (this.target == null) {
                return;
            }
            if (this.target != null && !this.target.isOpen()) {
                Object object = this.targetMonitor;
                synchronized (object) {
                    if (this.target != null && !this.target.isOpen()) {
                        if (this.target instanceof PublisherCallbackChannel) {
                            this.target.close();
                        }
                        if (this.channelList.contains(proxy)) {
                            this.channelList.remove(proxy);
                        }
                        this.target = null;
                        return;
                    }
                }
            }
            if (!this.channelList.contains(proxy)) {
                if (CachingConnectionFactory.this.logger.isTraceEnabled()) {
                    CachingConnectionFactory.this.logger.trace((Object)("Returning cached Channel: " + this.target));
                }
                this.channelList.addLast(proxy);
            }
        }

        private void physicalClose() throws Exception {
            if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                CachingConnectionFactory.this.logger.debug((Object)("Closing cached Channel: " + this.target));
            }
            if (this.target == null) {
                return;
            }
            try {
                if (CachingConnectionFactory.this.active && (CachingConnectionFactory.this.publisherConfirms || CachingConnectionFactory.this.publisherReturns)) {
                    ExecutorService executorService = CachingConnectionFactory.this.getExecutorService() != null ? CachingConnectionFactory.this.getExecutorService() : CachingConnectionFactory.this.deferredCloseExecutor;
                    final Channel channel = this.target;
                    executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (CachingConnectionFactory.this.publisherConfirms) {
                                    channel.waitForConfirmsOrDie(5000L);
                                } else {
                                    Thread.sleep(5000L);
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            catch (Exception exception) {
                            }
                            finally {
                                try {
                                    if (channel.isOpen()) {
                                        channel.close();
                                    }
                                }
                                catch (IOException iOException) {
                                }
                                catch (AlreadyClosedException alreadyClosedException) {
                                }
                                catch (TimeoutException timeoutException) {}
                            }
                        }
                    });
                } else {
                    this.target.close();
                }
            }
            catch (AlreadyClosedException e) {
                if (CachingConnectionFactory.this.logger.isTraceEnabled()) {
                    CachingConnectionFactory.this.logger.trace((Object)(this.target + " is already closed"));
                }
            }
            finally {
                this.target = null;
            }
        }
    }

    public static enum CacheMode {
        CHANNEL,
        CONNECTION;

    }
}

