/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.retry;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.util.Assert;

public class RepublishMessageRecoverer
implements MessageRecoverer {
    private static final Log logger = LogFactory.getLog(RepublishMessageRecoverer.class);
    private final AmqpTemplate errorTemplate;
    private final String errorRoutingKey;
    private volatile String errorRoutingKeyPrefix = "error.";
    private final String errorExchangeName;

    public RepublishMessageRecoverer(AmqpTemplate errorTemplate) {
        this(errorTemplate, null, null);
    }

    public RepublishMessageRecoverer(AmqpTemplate errorTemplate, String errorExchange) {
        this(errorTemplate, errorExchange, null);
    }

    public RepublishMessageRecoverer(AmqpTemplate errorTemplate, String errorExchange, String errorRoutingKey) {
        Assert.notNull((Object)errorTemplate, (String)"'errorTemplate' cannot be null");
        this.errorTemplate = errorTemplate;
        this.errorExchangeName = errorExchange;
        this.errorRoutingKey = errorRoutingKey;
    }

    public RepublishMessageRecoverer errorRoutingKeyPrefix(String errorRoutingKeyPrefix) {
        this.setErrorRoutingKeyPrefix(errorRoutingKeyPrefix);
        return this;
    }

    public void setErrorRoutingKeyPrefix(String errorRoutingKeyPrefix) {
        Assert.notNull((Object)errorRoutingKeyPrefix, (String)"'errorRoutingKeyPrefix' cannot be null");
        this.errorRoutingKeyPrefix = errorRoutingKeyPrefix;
    }

    @Override
    public void recover(Message message, Throwable cause) {
        Map headers = message.getMessageProperties().getHeaders();
        headers.put("x-exception-stacktrace", this.getStackTraceAsString(cause));
        headers.put("x-exception-message", cause.getCause() != null ? cause.getCause().getMessage() : cause.getMessage());
        headers.put("x-original-exchange", message.getMessageProperties().getReceivedExchange());
        headers.put("x-original-routingKey", message.getMessageProperties().getReceivedRoutingKey());
        if (null != this.errorExchangeName) {
            String routingKey = this.errorRoutingKey != null ? this.errorRoutingKey : this.prefixedOriginalRoutingKey(message);
            this.errorTemplate.send(this.errorExchangeName, routingKey, message);
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Republishing failed message to exchange " + this.errorExchangeName));
            }
        } else {
            String routingKey = this.prefixedOriginalRoutingKey(message);
            this.errorTemplate.send(routingKey, message);
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Republishing failed message to the template's default exchange with routing key " + routingKey));
            }
        }
    }

    private String prefixedOriginalRoutingKey(Message message) {
        return this.errorRoutingKeyPrefix + message.getMessageProperties().getReceivedRoutingKey();
    }

    private String getStackTraceAsString(Throwable cause) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        cause.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }
}

