/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.core;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.GetResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIllegalStateException;
import org.springframework.amqp.core.Address;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.ReceiveAndReplyCallback;
import org.springframework.amqp.core.ReceiveAndReplyMessageCallback;
import org.springframework.amqp.core.ReplyToAddressCallback;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactoryUtils;
import org.springframework.amqp.rabbit.connection.RabbitAccessor;
import org.springframework.amqp.rabbit.connection.RabbitResourceHolder;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.core.ChannelCallback;
import org.springframework.amqp.rabbit.core.RabbitOperations;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.PendingConfirm;
import org.springframework.amqp.rabbit.support.PublisherCallbackChannel;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RabbitTemplate
extends RabbitAccessor
implements RabbitOperations,
MessageListener,
PublisherCallbackChannel.Listener {
    private static final String DEFAULT_EXCHANGE = "";
    private static final String DEFAULT_ROUTING_KEY = "";
    private static final long DEFAULT_REPLY_TIMEOUT = 5000L;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private volatile String exchange = "";
    private volatile String routingKey = "";
    private volatile String queue;
    private volatile long replyTimeout = 5000L;
    private volatile MessageConverter messageConverter = new SimpleMessageConverter();
    private volatile MessagePropertiesConverter messagePropertiesConverter = new DefaultMessagePropertiesConverter();
    private volatile String encoding = "UTF-8";
    private volatile Queue replyQueue;
    private final Map<String, PendingReply> replyHolder = new ConcurrentHashMap<String, PendingReply>();
    private volatile ConfirmCallback confirmCallback;
    private volatile ReturnCallback returnCallback;
    private final Map<Object, SortedMap<Long, PendingConfirm>> pendingConfirms = new ConcurrentHashMap<Object, SortedMap<Long, PendingConfirm>>();
    private volatile boolean mandatory;
    private final String uuid = UUID.randomUUID().toString();
    private volatile String correlationKey = null;
    private volatile RetryTemplate retryTemplate;
    private final ReplyToAddressCallback<?> defaultReplyToAddressCallback = new ReplyToAddressCallback<Object>(){

        public Address getReplyToAddress(Message request, Object reply) {
            return RabbitTemplate.this.getReplyToAddress(request);
        }
    };

    public RabbitTemplate() {
        this.initDefaultStrategies();
    }

    public RabbitTemplate(ConnectionFactory connectionFactory) {
        this();
        this.setConnectionFactory(connectionFactory);
        this.afterPropertiesSet();
    }

    protected void initDefaultStrategies() {
        this.setMessageConverter((MessageConverter)new SimpleMessageConverter());
    }

    public void setExchange(String exchange) {
        this.exchange = exchange != null ? exchange : "";
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setReplyQueue(Queue replyQueue) {
        this.replyQueue = replyQueue;
    }

    public void setReplyTimeout(long replyTimeout) {
        this.replyTimeout = replyTimeout;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setMessagePropertiesConverter(MessagePropertiesConverter messagePropertiesConverter) {
        Assert.notNull((Object)messagePropertiesConverter, (String)"messagePropertiesConverter must not be null");
        this.messagePropertiesConverter = messagePropertiesConverter;
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setConfirmCallback(ConfirmCallback confirmCallback) {
        Assert.state((this.confirmCallback == null || this.confirmCallback == confirmCallback ? 1 : 0) != 0, (String)"Only one ConfirmCallback is supported by each RabbitTemplate");
        this.confirmCallback = confirmCallback;
    }

    public void setReturnCallback(ReturnCallback returnCallback) {
        Assert.state((this.returnCallback == null || this.returnCallback == returnCallback ? 1 : 0) != 0, (String)"Only one ReturnCallback is supported by each RabbitTemplate");
        this.returnCallback = returnCallback;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public void setCorrelationKey(String correlationKey) {
        Assert.hasText((String)correlationKey, (String)"'correlationKey' must not be null or empty");
        if (!correlationKey.trim().equals("correlationId")) {
            this.correlationKey = correlationKey.trim();
        }
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CorrelationData> getUnconfirmed(long age) {
        HashSet<CorrelationData> unconfirmed = new HashSet<CorrelationData>();
        Map<Object, SortedMap<Long, PendingConfirm>> map = this.pendingConfirms;
        synchronized (map) {
            long threshold = System.currentTimeMillis() - age;
            for (Map.Entry<Object, SortedMap<Long, PendingConfirm>> channelPendingConfirmEntry : this.pendingConfirms.entrySet()) {
                PendingConfirm pendingConfirm;
                SortedMap<Long, PendingConfirm> channelPendingConfirms = channelPendingConfirmEntry.getValue();
                Iterator<Map.Entry<Long, PendingConfirm>> iterator = channelPendingConfirms.entrySet().iterator();
                while (iterator.hasNext() && (pendingConfirm = iterator.next().getValue()).getTimestamp() < threshold) {
                    unconfirmed.add(pendingConfirm.getCorrelationData());
                    iterator.remove();
                }
            }
        }
        return unconfirmed.size() > 0 ? unconfirmed : null;
    }

    public void send(Message message) throws AmqpException {
        this.send(this.exchange, this.routingKey, message);
    }

    public void send(String routingKey, Message message) throws AmqpException {
        this.send(this.exchange, routingKey, message);
    }

    public void send(String exchange, String routingKey, Message message) throws AmqpException {
        this.send(exchange, routingKey, message, null);
    }

    public void send(final String exchange, final String routingKey, final Message message, final CorrelationData correlationData) throws AmqpException {
        this.execute(new ChannelCallback<Object>(){

            @Override
            public Object doInRabbit(Channel channel) throws Exception {
                RabbitTemplate.this.doSend(channel, exchange, routingKey, message, correlationData);
                return null;
            }
        });
    }

    public void convertAndSend(Object object) throws AmqpException {
        this.convertAndSend(this.exchange, this.routingKey, object, (CorrelationData)null);
    }

    @Deprecated
    public void correlationconvertAndSend(Object object, CorrelationData correlationData) throws AmqpException {
        this.correlationConvertAndSend(object, correlationData);
    }

    public void correlationConvertAndSend(Object object, CorrelationData correlationData) throws AmqpException {
        this.convertAndSend(this.exchange, this.routingKey, object, correlationData);
    }

    public void convertAndSend(String routingKey, Object object) throws AmqpException {
        this.convertAndSend(this.exchange, routingKey, object, (CorrelationData)null);
    }

    public void convertAndSend(String routingKey, Object object, CorrelationData correlationData) throws AmqpException {
        this.convertAndSend(this.exchange, routingKey, object, correlationData);
    }

    public void convertAndSend(String exchange, String routingKey, Object object) throws AmqpException {
        this.convertAndSend(exchange, routingKey, object, (CorrelationData)null);
    }

    public void convertAndSend(String exchange, String routingKey, Object object, CorrelationData correlationData) throws AmqpException {
        this.send(exchange, routingKey, this.convertMessageIfNecessary(object), correlationData);
    }

    public void convertAndSend(Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        this.convertAndSend(this.exchange, this.routingKey, message, messagePostProcessor);
    }

    public void convertAndSend(String routingKey, Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        this.convertAndSend(this.exchange, routingKey, message, messagePostProcessor, null);
    }

    public void convertAndSend(String routingKey, Object message, MessagePostProcessor messagePostProcessor, CorrelationData correlationData) throws AmqpException {
        this.convertAndSend(this.exchange, routingKey, message, messagePostProcessor, correlationData);
    }

    public void convertAndSend(String exchange, String routingKey, Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        this.convertAndSend(exchange, routingKey, message, messagePostProcessor, null);
    }

    public void convertAndSend(String exchange, String routingKey, Object message, MessagePostProcessor messagePostProcessor, CorrelationData correlationData) throws AmqpException {
        Message messageToSend = this.convertMessageIfNecessary(message);
        messageToSend = messagePostProcessor.postProcessMessage(messageToSend);
        this.send(exchange, routingKey, messageToSend, correlationData);
    }

    public Message receive() throws AmqpException {
        String queue = this.getRequiredQueue();
        return this.receive(queue);
    }

    public Message receive(final String queueName) {
        return this.execute(new ChannelCallback<Message>(){

            @Override
            public Message doInRabbit(Channel channel) throws IOException {
                GetResponse response = channel.basicGet(queueName, !RabbitTemplate.this.isChannelTransacted());
                if (response != null) {
                    long deliveryTag = response.getEnvelope().getDeliveryTag();
                    if (RabbitTemplate.this.isChannelLocallyTransacted(channel)) {
                        channel.basicAck(deliveryTag, false);
                        channel.txCommit();
                    } else if (RabbitTemplate.this.isChannelTransacted()) {
                        ConnectionFactoryUtils.registerDeliveryTag(RabbitTemplate.this.getConnectionFactory(), channel, deliveryTag);
                    }
                    return RabbitTemplate.this.buildMessageFromResponse(response);
                }
                return null;
            }
        });
    }

    public Object receiveAndConvert() throws AmqpException {
        return this.receiveAndConvert(this.getRequiredQueue());
    }

    public Object receiveAndConvert(String queueName) throws AmqpException {
        Message response = this.receive(queueName);
        if (response != null) {
            return this.getRequiredMessageConverter().fromMessage(response);
        }
        return null;
    }

    public <R, S> boolean receiveAndReply(ReceiveAndReplyCallback<R, S> callback) throws AmqpException {
        return this.receiveAndReply(this.getRequiredQueue(), callback);
    }

    public <R, S> boolean receiveAndReply(String queueName, ReceiveAndReplyCallback<R, S> callback) throws AmqpException {
        return this.receiveAndReply(queueName, callback, this.defaultReplyToAddressCallback);
    }

    public <R, S> boolean receiveAndReply(ReceiveAndReplyCallback<R, S> callback, String exchange, String routingKey) throws AmqpException {
        return this.receiveAndReply(this.getRequiredQueue(), callback, exchange, routingKey);
    }

    public <R, S> boolean receiveAndReply(String queueName, ReceiveAndReplyCallback<R, S> callback, final String replyExchange, final String replyRoutingKey) throws AmqpException {
        return this.receiveAndReply(queueName, callback, new ReplyToAddressCallback<S>(){

            public Address getReplyToAddress(Message request, S reply) {
                return new Address(null, replyExchange, replyRoutingKey);
            }
        });
    }

    public <R, S> boolean receiveAndReply(ReceiveAndReplyCallback<R, S> callback, ReplyToAddressCallback<S> replyToAddressCallback) throws AmqpException {
        return this.receiveAndReply(this.getRequiredQueue(), callback, replyToAddressCallback);
    }

    public <R, S> boolean receiveAndReply(String queueName, ReceiveAndReplyCallback<R, S> callback, ReplyToAddressCallback<S> replyToAddressCallback) throws AmqpException {
        return this.doReceiveAndReply(queueName, callback, replyToAddressCallback);
    }

    private <R, S> boolean doReceiveAndReply(final String queueName, final ReceiveAndReplyCallback<R, S> callback, final ReplyToAddressCallback<S> replyToAddressCallback) throws AmqpException {
        return this.execute(new ChannelCallback<Boolean>(){

            @Override
            public Boolean doInRabbit(Channel channel) throws Exception {
                boolean channelTransacted = RabbitTemplate.this.isChannelTransacted();
                GetResponse response = channel.basicGet(queueName, !channelTransacted);
                if (response != null) {
                    Object reply;
                    Message receiveMessage;
                    long deliveryTag = response.getEnvelope().getDeliveryTag();
                    boolean channelLocallyTransacted = RabbitTemplate.this.isChannelLocallyTransacted(channel);
                    if (channelLocallyTransacted) {
                        channel.basicAck(deliveryTag, false);
                    } else if (channelTransacted) {
                        ConnectionFactoryUtils.registerDeliveryTag(RabbitTemplate.this.getConnectionFactory(), channel, deliveryTag);
                    }
                    Object receive = receiveMessage = RabbitTemplate.this.buildMessageFromResponse(response);
                    if (!ReceiveAndReplyMessageCallback.class.isAssignableFrom(callback.getClass())) {
                        receive = RabbitTemplate.this.getRequiredMessageConverter().fromMessage(receiveMessage);
                    }
                    try {
                        reply = callback.handle(receive);
                    }
                    catch (ClassCastException e) {
                        StackTraceElement[] trace = e.getStackTrace();
                        if (trace[0].getMethodName().equals("handle") && trace[1].getFileName().equals("RabbitTemplate.java")) {
                            throw new IllegalArgumentException("ReceiveAndReplyCallback '" + callback + "' can't handle received object '" + receive + "'", e);
                        }
                        throw e;
                    }
                    if (reply != null) {
                        byte[] correlation;
                        Address replyTo = replyToAddressCallback.getReplyToAddress(receiveMessage, reply);
                        Message replyMessage = RabbitTemplate.this.convertMessageIfNecessary(reply);
                        MessageProperties receiveMessageProperties = receiveMessage.getMessageProperties();
                        MessageProperties replyMessageProperties = replyMessage.getMessageProperties();
                        Object object = correlation = RabbitTemplate.this.correlationKey == null ? receiveMessageProperties.getCorrelationId() : (Object)receiveMessageProperties.getHeaders().get(RabbitTemplate.this.correlationKey);
                        if (RabbitTemplate.this.correlationKey == null || correlation == null) {
                            String messageId;
                            if (correlation == null && (messageId = receiveMessageProperties.getMessageId()) != null) {
                                correlation = messageId.getBytes(RabbitTemplate.this.encoding);
                            }
                            replyMessageProperties.setCorrelationId(correlation);
                        } else {
                            replyMessageProperties.setHeader(RabbitTemplate.this.correlationKey, (Object)correlation);
                        }
                        RabbitTemplate.this.doSend(channel, replyTo.getExchangeName(), replyTo.getRoutingKey(), replyMessage, null);
                    } else if (channelLocallyTransacted) {
                        channel.txCommit();
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public Message sendAndReceive(Message message) throws AmqpException {
        return this.doSendAndReceive(this.exchange, this.routingKey, message);
    }

    public Message sendAndReceive(String routingKey, Message message) throws AmqpException {
        return this.doSendAndReceive(this.exchange, routingKey, message);
    }

    public Message sendAndReceive(String exchange, String routingKey, Message message) throws AmqpException {
        return this.doSendAndReceive(exchange, routingKey, message);
    }

    public Object convertSendAndReceive(Object message) throws AmqpException {
        return this.convertSendAndReceive(this.exchange, this.routingKey, message, null);
    }

    public Object convertSendAndReceive(String routingKey, Object message) throws AmqpException {
        return this.convertSendAndReceive(this.exchange, routingKey, message, null);
    }

    public Object convertSendAndReceive(String exchange, String routingKey, Object message) throws AmqpException {
        return this.convertSendAndReceive(exchange, routingKey, message, null);
    }

    public Object convertSendAndReceive(Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        return this.convertSendAndReceive(this.exchange, this.routingKey, message, messagePostProcessor);
    }

    public Object convertSendAndReceive(String routingKey, Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        return this.convertSendAndReceive(this.exchange, routingKey, message, messagePostProcessor);
    }

    public Object convertSendAndReceive(String exchange, String routingKey, Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        Message replyMessage;
        Message requestMessage = this.convertMessageIfNecessary(message);
        if (messagePostProcessor != null) {
            requestMessage = messagePostProcessor.postProcessMessage(requestMessage);
        }
        if ((replyMessage = this.doSendAndReceive(exchange, routingKey, requestMessage)) == null) {
            return null;
        }
        return this.getRequiredMessageConverter().fromMessage(replyMessage);
    }

    protected Message convertMessageIfNecessary(Object object) {
        if (object instanceof Message) {
            return (Message)object;
        }
        return this.getRequiredMessageConverter().toMessage(object, new MessageProperties());
    }

    protected Message doSendAndReceive(String exchange, String routingKey, Message message) {
        if (this.replyQueue == null) {
            return this.doSendAndReceiveWithTemporary(exchange, routingKey, message);
        }
        return this.doSendAndReceiveWithFixed(exchange, routingKey, message);
    }

    protected Message doSendAndReceiveWithTemporary(final String exchange, final String routingKey, final Message message) {
        return this.execute(new ChannelCallback<Message>(){

            @Override
            public Message doInRabbit(Channel channel) throws Exception {
                final ArrayBlockingQueue replyHandoff = new ArrayBlockingQueue(1);
                Assert.isNull((Object)message.getMessageProperties().getReplyTo(), (String)"Send-and-receive methods can only be used if the Message does not already have a replyTo property.");
                AMQP.Queue.DeclareOk queueDeclaration = channel.queueDeclare();
                String replyTo = queueDeclaration.getQueue();
                message.getMessageProperties().setReplyTo(replyTo);
                String consumerTag = UUID.randomUUID().toString();
                DefaultConsumer consumer = new DefaultConsumer(channel){

                    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                        MessageProperties messageProperties = RabbitTemplate.this.messagePropertiesConverter.toMessageProperties(properties, envelope, RabbitTemplate.this.encoding);
                        Message reply = new Message(body, messageProperties);
                        if (RabbitTemplate.this.logger.isTraceEnabled()) {
                            RabbitTemplate.this.logger.trace((Object)("Message received " + reply));
                        }
                        try {
                            replyHandoff.put(reply);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                };
                channel.basicConsume(replyTo, true, consumerTag, true, true, null, (Consumer)consumer);
                RabbitTemplate.this.doSend(channel, exchange, routingKey, message, null);
                Message reply = RabbitTemplate.this.replyTimeout < 0L ? (Message)replyHandoff.take() : (Message)replyHandoff.poll(RabbitTemplate.this.replyTimeout, TimeUnit.MILLISECONDS);
                channel.basicCancel(consumerTag);
                return reply;
            }
        });
    }

    protected Message doSendAndReceiveWithFixed(final String exchange, final String routingKey, final Message message) {
        return this.execute(new ChannelCallback<Message>(){

            @Override
            public Message doInRabbit(Channel channel) throws Exception {
                PendingReply pendingReply = new PendingReply();
                String messageTag = UUID.randomUUID().toString();
                RabbitTemplate.this.replyHolder.put(messageTag, pendingReply);
                String savedReplyTo = message.getMessageProperties().getReplyTo();
                pendingReply.setSavedReplyTo(savedReplyTo);
                if (StringUtils.hasLength((String)savedReplyTo) && RabbitTemplate.this.logger.isDebugEnabled()) {
                    RabbitTemplate.this.logger.debug((Object)("Replacing replyTo header:" + savedReplyTo + " in favor of template's configured reply-queue:" + RabbitTemplate.this.replyQueue.getName()));
                }
                message.getMessageProperties().setReplyTo(RabbitTemplate.this.replyQueue.getName());
                String savedCorrelation = null;
                if (RabbitTemplate.this.correlationKey == null) {
                    byte[] correlationId = message.getMessageProperties().getCorrelationId();
                    if (correlationId != null) {
                        savedCorrelation = new String(correlationId, RabbitTemplate.this.encoding);
                    }
                } else {
                    savedCorrelation = (String)message.getMessageProperties().getHeaders().get(RabbitTemplate.this.correlationKey);
                }
                pendingReply.setSavedCorrelation(savedCorrelation);
                if (RabbitTemplate.this.correlationKey == null) {
                    message.getMessageProperties().setCorrelationId(messageTag.getBytes(RabbitTemplate.this.encoding));
                } else {
                    message.getMessageProperties().setHeader(RabbitTemplate.this.correlationKey, (Object)messageTag);
                }
                if (RabbitTemplate.this.logger.isDebugEnabled()) {
                    RabbitTemplate.this.logger.debug((Object)("Sending message with tag " + messageTag));
                }
                RabbitTemplate.this.doSend(channel, exchange, routingKey, message, null);
                LinkedBlockingQueue<Message> replyHandoff = pendingReply.getQueue();
                Message reply = RabbitTemplate.this.replyTimeout < 0L ? replyHandoff.take() : replyHandoff.poll(RabbitTemplate.this.replyTimeout, TimeUnit.MILLISECONDS);
                RabbitTemplate.this.replyHolder.remove(messageTag);
                return reply;
            }
        });
    }

    @Override
    public <T> T execute(final ChannelCallback<T> action) {
        if (this.retryTemplate != null) {
            try {
                return (T)this.retryTemplate.execute(new RetryCallback<T>(){

                    public T doWithRetry(RetryContext context) throws Exception {
                        return RabbitTemplate.this.doExecute(action);
                    }
                });
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw RabbitExceptionTranslator.convertRabbitAccessException(e);
            }
        }
        return this.doExecute(action);
    }

    private <T> T doExecute(ChannelCallback<T> action) {
        Assert.notNull(action, (String)"Callback object must not be null");
        RabbitResourceHolder resourceHolder = this.getTransactionalResourceHolder();
        Channel channel = resourceHolder.getChannel();
        if (this.confirmCallback != null || this.returnCallback != null) {
            this.addListener(channel);
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing callback on RabbitMQ Channel: " + channel));
            }
            T t = action.doInRabbit(channel);
            return t;
        }
        catch (Exception ex) {
            if (this.isChannelLocallyTransacted(channel)) {
                resourceHolder.rollbackAll();
            }
            throw this.convertRabbitAccessException(ex);
        }
        finally {
            ConnectionFactoryUtils.releaseResources(resourceHolder);
        }
    }

    protected void doSend(Channel channel, String exchange, String routingKey, Message message, CorrelationData correlationData) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Publishing message on exchange [" + exchange + "], routingKey = [" + routingKey + "]"));
        }
        if (exchange == null) {
            exchange = this.exchange;
        }
        if (routingKey == null) {
            routingKey = this.routingKey;
        }
        if (this.confirmCallback != null && channel instanceof PublisherCallbackChannel) {
            PublisherCallbackChannel publisherCallbackChannel = (PublisherCallbackChannel)channel;
            publisherCallbackChannel.addPendingConfirm(this, channel.getNextPublishSeqNo(), new PendingConfirm(correlationData, System.currentTimeMillis()));
        }
        boolean mandatory = this.returnCallback != null && this.mandatory;
        MessageProperties messageProperties = message.getMessageProperties();
        if (mandatory) {
            messageProperties.getHeaders().put("spring_return_correlation", this.uuid);
        }
        AMQP.BasicProperties convertedMessageProperties = this.messagePropertiesConverter.fromMessageProperties(messageProperties, this.encoding);
        channel.basicPublish(exchange, routingKey, mandatory, convertedMessageProperties, message.getBody());
        if (this.isChannelLocallyTransacted(channel)) {
            RabbitUtils.commitIfNecessary(channel);
        }
    }

    protected boolean isChannelLocallyTransacted(Channel channel) {
        return this.isChannelTransacted() && !ConnectionFactoryUtils.isChannelTransactional(channel, this.getConnectionFactory());
    }

    private Message buildMessageFromResponse(GetResponse response) {
        MessageProperties messageProps = this.messagePropertiesConverter.toMessageProperties(response.getProps(), response.getEnvelope(), this.encoding);
        messageProps.setMessageCount(Integer.valueOf(response.getMessageCount()));
        return new Message(response.getBody(), messageProps);
    }

    private MessageConverter getRequiredMessageConverter() throws IllegalStateException {
        MessageConverter converter = this.getMessageConverter();
        if (converter == null) {
            throw new AmqpIllegalStateException("No 'messageConverter' specified. Check configuration of RabbitTemplate.");
        }
        return converter;
    }

    private String getRequiredQueue() throws IllegalStateException {
        String name = this.queue;
        if (name == null) {
            throw new AmqpIllegalStateException("No 'queue' specified. Check configuration of RabbitTemplate.");
        }
        return name;
    }

    private Address getReplyToAddress(Message request) throws AmqpException {
        Address replyTo = request.getMessageProperties().getReplyToAddress();
        if (replyTo == null) {
            if (this.exchange == null) {
                throw new AmqpException("Cannot determine ReplyTo message property value: Request message does not contain reply-to property, and no default Exchange was set.");
            }
            replyTo = new Address(null, this.exchange, this.routingKey);
        }
        return replyTo;
    }

    private void addListener(Channel channel) {
        if (channel instanceof PublisherCallbackChannel) {
            PublisherCallbackChannel publisherCallbackChannel = (PublisherCallbackChannel)channel;
            SortedMap<Long, PendingConfirm> pendingConfirms = publisherCallbackChannel.addListener(this);
            if (!this.pendingConfirms.containsKey(channel)) {
                this.pendingConfirms.put(channel, pendingConfirms);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Added pending confirms for " + channel + " to map, size now " + this.pendingConfirms.size()));
                }
            }
        } else {
            throw new IllegalStateException("Channel does not support confirms or returns; is the connection factory configured for confirms or returns?");
        }
    }

    @Override
    public void handleConfirm(PendingConfirm pendingConfirm, boolean ack) {
        if (this.confirmCallback != null) {
            this.confirmCallback.confirm(pendingConfirm.getCorrelationData(), ack);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.warn((Object)"Confirm received but no callback available");
        }
    }

    @Override
    public void handleReturn(int replyCode, String replyText, String exchange, String routingKey, AMQP.BasicProperties properties, byte[] body) throws IOException {
        if (this.returnCallback == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"Returned message but no callback available");
            }
        } else {
            properties.getHeaders().remove("spring_return_correlation");
            MessageProperties messageProperties = this.messagePropertiesConverter.toMessageProperties(properties, null, this.encoding);
            Message returnedMessage = new Message(body, messageProperties);
            this.returnCallback.returnedMessage(returnedMessage, replyCode, replyText, exchange, routingKey);
        }
    }

    @Override
    public boolean isConfirmListener() {
        return this.confirmCallback != null;
    }

    @Override
    public boolean isReturnListener() {
        return this.returnCallback != null;
    }

    @Override
    public void removePendingConfirmsReference(Channel channel, SortedMap<Long, PendingConfirm> unconfirmed) {
        this.pendingConfirms.remove(channel);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removed pending confirms for " + channel + " from map, size now " + this.pendingConfirms.size()));
        }
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    public void onMessage(Message message) {
        try {
            String messageTag = this.correlationKey == null ? new String(message.getMessageProperties().getCorrelationId(), this.encoding) : (String)message.getMessageProperties().getHeaders().get(this.correlationKey);
            if (messageTag == null) {
                this.logger.error((Object)"No correlation header in reply");
                return;
            }
            PendingReply pendingReply = this.replyHolder.get(messageTag);
            if (pendingReply == null) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("Reply received after timeout for " + messageTag));
                }
            } else {
                String savedCorrelation = pendingReply.getSavedCorrelation();
                if (this.correlationKey == null) {
                    if (savedCorrelation == null) {
                        message.getMessageProperties().setCorrelationId(null);
                    } else {
                        message.getMessageProperties().setCorrelationId(savedCorrelation.getBytes(this.encoding));
                    }
                } else if (savedCorrelation != null) {
                    message.getMessageProperties().setHeader(this.correlationKey, (Object)savedCorrelation);
                } else {
                    message.getMessageProperties().getHeaders().remove(this.correlationKey);
                }
                String savedReplyTo = pendingReply.getSavedReplyTo();
                message.getMessageProperties().setReplyTo(savedReplyTo);
                LinkedBlockingQueue<Message> queue = pendingReply.getQueue();
                queue.add(message);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Reply received for " + messageTag));
                    if (savedReplyTo != null) {
                        this.logger.debug((Object)("Restored replyTo to " + savedReplyTo));
                    }
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new AmqpIllegalStateException("Invalid Character Set:" + this.encoding, (Throwable)e);
        }
    }

    public static interface ReturnCallback {
        public void returnedMessage(Message var1, int var2, String var3, String var4, String var5);
    }

    public static interface ConfirmCallback {
        public void confirm(CorrelationData var1, boolean var2);
    }

    private static class PendingReply {
        private volatile String savedReplyTo;
        private volatile String savedCorrelation;
        private final LinkedBlockingQueue<Message> queue = new LinkedBlockingQueue();

        public String getSavedReplyTo() {
            return this.savedReplyTo;
        }

        public void setSavedReplyTo(String savedReplyTo) {
            this.savedReplyTo = savedReplyTo;
        }

        public String getSavedCorrelation() {
            return this.savedCorrelation;
        }

        public void setSavedCorrelation(String savedCorrelation) {
            this.savedCorrelation = savedCorrelation;
        }

        public LinkedBlockingQueue<Message> getQueue() {
            return this.queue;
        }
    }
}

