/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.Collections;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.rabbit.config.AbstractExchangeParser;
import org.springframework.amqp.rabbit.config.BindingFactoryBean;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class DirectExchangeParser
extends AbstractExchangeParser {
    private static final String BINDING_KEY_ATTR = "key";

    protected Class<?> getBeanClass(Element element) {
        return DirectExchange.class;
    }

    @Override
    protected BeanDefinitionBuilder parseBinding(String exchangeName, Element binding, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(BindingFactoryBean.class);
        this.parseDestination(binding, parserContext, builder);
        builder.addPropertyValue("exchange", (Object)new TypedStringValue(exchangeName));
        String bindingKey = binding.getAttribute(BINDING_KEY_ATTR);
        if (!StringUtils.hasText((String)bindingKey)) {
            bindingKey = "";
        }
        builder.addPropertyValue("routingKey", (Object)new TypedStringValue(bindingKey));
        builder.addPropertyValue("arguments", Collections.emptyMap());
        return builder;
    }
}

