/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rabbit.stream.micrometer;

import com.rabbitmq.stream.Message;
import io.micrometer.observation.transport.SenderContext;
import java.util.Map;

public class RabbitStreamMessageSenderContext
extends SenderContext<Message> {
    private final String beanName;
    private final String destination;

    public RabbitStreamMessageSenderContext(Message message, String beanName, String destination) {
        super((carrier, key, value) -> {
            Map props = message.getApplicationProperties();
            if (props != null) {
                props.put(key, value);
            }
        });
        this.setCarrier(message);
        this.beanName = beanName;
        this.destination = destination;
        this.setRemoteServiceName("RabbitMQ Stream");
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getDestination() {
        return this.destination;
    }
}

