/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rabbit.stream.retry;

import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.MessageHandler;
import org.springframework.amqp.rabbit.config.StatelessRetryOperationsInterceptorFactoryBean;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.rabbit.stream.retry.StreamMessageRecoverer;
import org.springframework.retry.interceptor.MethodInvocationRecoverer;

public class StreamRetryOperationsInterceptorFactoryBean
extends StatelessRetryOperationsInterceptorFactoryBean {
    protected MethodInvocationRecoverer<?> createRecoverer() {
        return (args, cause) -> {
            StreamMessageRecoverer messageRecoverer = (StreamMessageRecoverer)this.getMessageRecoverer();
            Object arg = args[0];
            if (arg instanceof org.springframework.amqp.core.Message) {
                return super.recover(args, cause);
            }
            if (messageRecoverer == null) {
                this.logger.warn((Object)("Message(s) dropped on recovery: " + arg), cause);
            } else {
                messageRecoverer.recover((Message)arg, (MessageHandler.Context)args[1], cause);
            }
            return null;
        };
    }

    public void setStreamMessageRecoverer(StreamMessageRecoverer messageRecoverer) {
        super.setMessageRecoverer((MessageRecoverer)messageRecoverer);
    }

    public void setMessageRecoverer(MessageRecoverer messageRecoverer) {
        throw new UnsupportedOperationException("Use setStreamMessageRecoverer() instead");
    }
}

