/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.junit;

import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.amqp.rabbit.junit.JUnitUtils;
import org.springframework.amqp.rabbit.junit.LongRunning;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.StringUtils;

public class LongRunningIntegrationTestCondition
implements ExecutionCondition {
    public static final String RUN_LONG_INTEGRATION_TESTS = "RUN_LONG_INTEGRATION_TESTS";
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"@LongRunning is not present");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional element = context.getElement();
        MergedAnnotations annotations = MergedAnnotations.from((AnnotatedElement)((AnnotatedElement)element.get()), (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        MergedAnnotation mergedAnnotation = annotations.get(LongRunning.class);
        if (mergedAnnotation.isPresent()) {
            LongRunning longRunning = (LongRunning)mergedAnnotation.synthesize();
            String property = longRunning.value();
            if (!StringUtils.hasText((String)property)) {
                property = RUN_LONG_INTEGRATION_TESTS;
            }
            return JUnitUtils.parseBooleanProperty(property) ? ConditionEvaluationResult.enabled((String)"Long running tests must run") : ConditionEvaluationResult.disabled((String)"Long running tests are skipped");
        }
        return ENABLED;
    }
}

