/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.junit;

import java.io.IOException;
import java.time.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.BeforeAll;
import org.testcontainers.junit.jupiter.Testcontainers;
import org.testcontainers.rabbitmq.RabbitMQContainer;
import org.testcontainers.utility.DockerImageName;

@Testcontainers(disabledWithoutDocker=true)
public abstract class AbstractTestContainerTests {
    private static final Log LOG = LogFactory.getLog(AbstractTestContainerTests.class);
    protected static final @Nullable RabbitMQContainer RABBITMQ;

    @BeforeAll
    static void startContainer() throws IOException, InterruptedException {
        if (RABBITMQ != null) {
            RABBITMQ.start();
            RABBITMQ.execInContainer(new String[]{"rabbitmq-plugins", "enable", "rabbitmq_stream"});
        } else {
            LOG.info((Object)"The local RabbitMQ broker will be used instead of Testcontainers.");
        }
    }

    public static int amqpPort() {
        return RABBITMQ != null ? RABBITMQ.getAmqpPort() : 5672;
    }

    public static int managementPort() {
        return RABBITMQ != null ? RABBITMQ.getMappedPort(15672) : 15672;
    }

    public static int streamPort() {
        return RABBITMQ != null ? RABBITMQ.getMappedPort(5552) : 5552;
    }

    public static String restUri() {
        return RABBITMQ != null ? RABBITMQ.getHttpUrl() + "/api/" : "http://localhost:" + AbstractTestContainerTests.managementPort() + "/api/";
    }

    static {
        if (System.getProperty("spring.rabbit.use.local.server") == null && System.getenv("SPRING_RABBIT_USE_LOCAL_SERVER") == null) {
            Object image = "rabbitmq:management";
            String cache = System.getenv().get("IMAGE_CACHE");
            if (cache != null) {
                image = cache + (String)image;
            }
            DockerImageName imageName = DockerImageName.parse((String)image).asCompatibleSubstituteFor("rabbitmq");
            RABBITMQ = (RabbitMQContainer)((RabbitMQContainer)new RabbitMQContainer(imageName).withExposedPorts(new Integer[]{5672, 15672, 5552})).withStartupTimeout(Duration.ofMinutes(2L));
        } else {
            RABBITMQ = null;
        }
    }
}

