/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.junit;

import java.time.Duration;
import org.testcontainers.containers.RabbitMQContainer;
import org.testcontainers.utility.DockerImageName;

public abstract class AbstractTestContainerTests {
    protected static final RabbitMQContainer RABBITMQ;

    public static int amqpPort() {
        return RABBITMQ != null ? RABBITMQ.getAmqpPort() : 5672;
    }

    public static int managementPort() {
        return RABBITMQ != null ? RABBITMQ.getMappedPort(15672) : 15672;
    }

    public static int streamPort() {
        return RABBITMQ != null ? RABBITMQ.getMappedPort(5552) : 5552;
    }

    public static String restUri() {
        return RABBITMQ.getHttpUrl() + "/api/";
    }

    static {
        if (System.getProperty("spring.rabbit.use.local.server") == null && System.getenv("SPRING_RABBIT_USE_LOCAL_SERVER") == null) {
            Object image = "rabbitmq:3.11-management";
            String cache = System.getenv().get("IMAGE_CACHE");
            if (cache != null) {
                image = cache + (String)image;
            }
            DockerImageName imageName = DockerImageName.parse((String)image).asCompatibleSubstituteFor("rabbitmq");
            RABBITMQ = (RabbitMQContainer)((RabbitMQContainer)new RabbitMQContainer(imageName).withExposedPorts(new Integer[]{5672, 15672, 5552})).withPluginsEnabled(new String[]{"rabbitmq_stream"}).withStartupTimeout(Duration.ofMinutes(2L));
            RABBITMQ.start();
        } else {
            RABBITMQ = null;
        }
    }
}

