/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.junit;

import com.rabbitmq.client.ConnectionFactory;
import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.springframework.amqp.rabbit.junit.BrokerRunning;
import org.springframework.amqp.rabbit.junit.RabbitAvailable;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

public class RabbitAvailableCondition
implements ExecutionCondition,
AfterAllCallback,
ParameterResolver {
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"@RabbitAvailable is not present");
    private static final ThreadLocal<BrokerRunning> brokerRunningHolder = new ThreadLocal();

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional element = context.getElement();
        RabbitAvailable rabbit = (RabbitAvailable)AnnotationUtils.findAnnotation((AnnotatedElement)((AnnotatedElement)element.get()), RabbitAvailable.class);
        if (rabbit != null) {
            try {
                String[] queues = rabbit.queues();
                BrokerRunning brokerRunning = (BrokerRunning)((Object)this.getStore(context).get((Object)"brokerRunning", BrokerRunning.class));
                if (brokerRunning == null) {
                    brokerRunning = rabbit.management() ? BrokerRunning.isBrokerAndManagementRunningWithEmptyQueues(queues) : BrokerRunning.isRunningWithEmptyQueues(queues);
                }
                brokerRunning.isUp();
                brokerRunningHolder.set(brokerRunning);
                ExtensionContext.Store store = this.getStore(context);
                store.put((Object)"brokerRunning", (Object)brokerRunning);
                store.put((Object)"queuesToDelete", (Object)queues);
                return ConditionEvaluationResult.enabled((String)"RabbitMQ is available");
            }
            catch (Exception e) {
                if (BrokerRunning.fatal()) {
                    throw new IllegalStateException("Required RabbitMQ is not available");
                }
                return ConditionEvaluationResult.disabled((String)"RabbitMQ is not available");
            }
        }
        return ENABLED;
    }

    public void afterAll(ExtensionContext context) throws Exception {
        brokerRunningHolder.remove();
        ExtensionContext.Store store = this.getStore(context);
        BrokerRunning brokerRunning = (BrokerRunning)((Object)store.remove((Object)"brokerRunning", BrokerRunning.class));
        if (brokerRunning != null) {
            brokerRunning.removeTestQueues(new String[0]);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type = parameterContext.getParameter().getType();
        return type.equals(ConnectionFactory.class) || type.equals(BrokerRunning.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        BrokerRunning brokerRunning = this.getParentStore(context).get((Object)"brokerRunning", BrokerRunning.class) == null ? (BrokerRunning)((Object)this.getStore(context).get((Object)"brokerRunning", BrokerRunning.class)) : (BrokerRunning)((Object)this.getParentStore(context).get((Object)"brokerRunning", BrokerRunning.class));
        Assert.state((brokerRunning != null ? 1 : 0) != 0, (String)"Could not find brokerRunning instance");
        Class<?> type = parameterContext.getParameter().getType();
        return type.equals(ConnectionFactory.class) ? brokerRunning.getConnectionFactory() : brokerRunning;
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context}));
    }

    private ExtensionContext.Store getParentStore(ExtensionContext context) {
        ExtensionContext parent = (ExtensionContext)context.getParent().get();
        return parent.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), parent}));
    }

    public static BrokerRunning getBrokerRunning() {
        return brokerRunningHolder.get();
    }
}

