/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.exec;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.springframework.util.exec.Escape;
import org.springframework.util.exec.Os;

public class Background {
    public static void exec(String[] cmd) throws IOException {
        File devNull;
        if (Os.isFamily("unix")) {
            devNull = new File("/dev/null");
        } else if (Os.isFamily("windows")) {
            devNull = new File("NUL");
        } else {
            throw new IllegalStateException("Unhandled Java environment");
        }
        Background.exec(cmd, devNull, false, devNull, false);
    }

    public static void exec(String[] cmd, File outFile, boolean appendOut, File errFile, boolean appendErr) throws IOException {
        if (Os.isFamily("unix")) {
            Background.execUnix(cmd, outFile, appendOut, errFile, appendErr);
        } else if (Os.isFamily("windows")) {
            Background.execWin(cmd, outFile, appendOut, errFile, appendErr);
        } else {
            throw new IllegalStateException("Unhandled Java environment");
        }
    }

    private static void execUnix(String[] cmd, File outFile, boolean appendOut, File errFile, boolean appendErr) throws IOException {
        StringBuffer escaped = new StringBuffer();
        for (int i = 0; i < cmd.length; ++i) {
            escaped.append(Escape.escape(cmd[i]));
            escaped.append(" ");
        }
        String[] execCmd = new String[]{"/bin/sh", "-c", escaped.toString() + (appendOut ? ">>" : ">") + Escape.escape(outFile.getAbsolutePath()) + " 2" + (appendErr ? ">>" : " >") + Escape.escape(errFile.getAbsolutePath()) + " </dev/null &"};
        Process p = Runtime.getRuntime().exec(execCmd);
        try {
            p.waitFor();
        }
        catch (Exception exc) {
            throw new IOException("Unable to properly background process: " + exc.getMessage(), exc);
        }
    }

    private static void execWin(String[] cmd, File outFile, boolean appendOut, File errFile, boolean appendErr) throws IOException {
        ArrayList<String> tmpCmd = new ArrayList<String>();
        tmpCmd.add("cmd");
        tmpCmd.add("/c");
        tmpCmd.add("start");
        tmpCmd.add("/b");
        tmpCmd.add("\"\"");
        tmpCmd.add("/MIN");
        for (int i = 0; i < cmd.length; ++i) {
            tmpCmd.add(cmd[i]);
        }
        tmpCmd.add((appendOut ? ">>" : ">") + Escape.escape(outFile.getAbsolutePath()));
        tmpCmd.add((outFile.equals(errFile) ? " 2&" : " 2") + (appendErr ? ">>" : " >") + Escape.escape(errFile.getAbsolutePath()));
        Runtime.getRuntime().exec(tmpCmd.toArray(cmd));
    }

    public static void main(String[] args) throws Exception {
        Background.exec(new String[]{"javaq", "foo bar", "bar"}, new File("garfo"), true, new File("barfo"), true);
    }
}

