/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.erlang.core;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import org.springframework.erlang.ErlangBadRpcException;
import org.springframework.erlang.ErlangErrorRpcException;
import org.springframework.erlang.OtpException;
import org.springframework.erlang.connection.Connection;
import org.springframework.erlang.connection.ConnectionFactory;
import org.springframework.erlang.connection.ConnectionFactoryUtils;
import org.springframework.erlang.core.ConnectionCallback;
import org.springframework.erlang.core.ErlangOperations;
import org.springframework.erlang.support.ErlangAccessor;
import org.springframework.erlang.support.ErlangUtils;
import org.springframework.erlang.support.converter.ErlangConverter;
import org.springframework.erlang.support.converter.SimpleErlangConverter;
import org.springframework.util.Assert;

public class ErlangTemplate
extends ErlangAccessor
implements ErlangOperations {
    private volatile ErlangConverter erlangConverter = new SimpleErlangConverter();

    public ErlangTemplate(ConnectionFactory connectionFactory) {
        this.setConnectionFactory(connectionFactory);
        this.afterPropertiesSet();
    }

    @Override
    public OtpErlangObject executeErlangRpc(final String module, final String function, final OtpErlangList args) {
        return this.execute(new ConnectionCallback<OtpErlangObject>(){

            @Override
            public OtpErlangObject doInConnection(Connection connection) throws Exception {
                ErlangTemplate.this.logger.debug((Object)("Sending RPC for module [" + module + "] function [" + function + "] args [" + args));
                connection.sendRPC(module, function, args);
                OtpErlangObject response = connection.receiveRPC();
                ErlangTemplate.this.logger.debug((Object)("Response received = " + response.toString()));
                ErlangTemplate.this.handleResponseError(module, function, response);
                return response;
            }
        });
    }

    public void handleResponseError(String module, String function, OtpErlangObject result) {
        OtpErlangTuple msg;
        if (result instanceof OtpErlangTuple && (msg = (OtpErlangTuple)result).elementAt(0) instanceof OtpErlangAtom) {
            OtpErlangAtom responseAtom = (OtpErlangAtom)msg.elementAt(0);
            if (responseAtom.atomValue().equals("badrpc")) {
                if (msg.elementAt(1) instanceof OtpErlangTuple) {
                    throw new ErlangBadRpcException((OtpErlangTuple)msg.elementAt(1));
                }
                throw new ErlangBadRpcException(msg.elementAt(1).toString());
            }
            if (responseAtom.atomValue().equals("error")) {
                if (msg.elementAt(1) instanceof OtpErlangTuple) {
                    throw new ErlangErrorRpcException((OtpErlangTuple)msg.elementAt(1));
                }
                throw new ErlangErrorRpcException(msg.elementAt(1).toString());
            }
        }
    }

    @Override
    public OtpErlangObject executeErlangRpc(String module, String function, OtpErlangObject ... args) {
        return this.executeRpc(module, function, new OtpErlangList(args));
    }

    @Override
    public OtpErlangObject executeRpc(String module, String function, Object ... args) {
        return this.executeErlangRpc(module, function, (OtpErlangList)this.erlangConverter.toErlang(args));
    }

    @Override
    public Object executeAndConvertRpc(String module, String function, ErlangConverter converterToUse, Object ... args) {
        return converterToUse.fromErlang(this.executeRpc(module, function, converterToUse.toErlang(args)));
    }

    @Override
    public Object executeAndConvertRpc(String module, String function, Object ... args) {
        return this.erlangConverter.fromErlangRpc(module, function, this.executeErlangRpc(module, function, (OtpErlangList)this.erlangConverter.toErlang(args)));
    }

    public ErlangConverter getErlangConverter() {
        return this.erlangConverter;
    }

    public void setErlangConverter(ErlangConverter erlangConverter) {
        this.erlangConverter = erlangConverter;
    }

    @Override
    public <T> T execute(ConnectionCallback<T> action) throws OtpException {
        Assert.notNull(action, (String)"Callback object must not be null");
        Connection con = null;
        try {
            con = this.createConnection();
            T t = action.doInConnection(con);
            return t;
        }
        catch (OtpException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw this.convertOtpAccessException(ex);
        }
        finally {
            ConnectionFactoryUtils.releaseConnection(con, this.getConnectionFactory());
        }
    }

    @Override
    protected OtpException convertOtpAccessException(Exception ex) {
        return ErlangUtils.convertOtpAccessException(ex);
    }
}

