/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.AbstractMessageConverter;
import org.springframework.amqp.support.converter.ClassMapper;
import org.springframework.amqp.support.converter.DefaultJacksonJavaTypeMapper;
import org.springframework.amqp.support.converter.JacksonJavaTypeMapper;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.SmartMessageConverter;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;

public abstract class AbstractJacksonMessageConverter
extends AbstractMessageConverter
implements BeanClassLoaderAware,
SmartMessageConverter {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final ObjectMapper objectMapper;
    private MimeType supportedContentType;
    private @Nullable String supportedCTCharset;
    private @Nullable ClassMapper classMapper = null;
    private Charset defaultCharset = DEFAULT_CHARSET;
    private boolean typeMapperSet;
    private @Nullable ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
    private JacksonJavaTypeMapper javaTypeMapper = new DefaultJacksonJavaTypeMapper();
    private boolean charsetIsUtf8 = true;
    private boolean assumeSupportedContentType = true;
    private boolean alwaysConvertToInferredType;
    private boolean nullAsOptionalEmpty;

    protected AbstractJacksonMessageConverter(ObjectMapper objectMapper, MimeType contentType, String ... trustedPackages) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null");
        Assert.notNull((Object)contentType, (String)"'contentType' must not be null");
        this.objectMapper = objectMapper;
        this.supportedContentType = contentType;
        this.supportedCTCharset = this.supportedContentType.getParameter("charset");
        ((DefaultJacksonJavaTypeMapper)this.javaTypeMapper).setTrustedPackages(trustedPackages);
    }

    protected MimeType getSupportedContentType() {
        return this.supportedContentType;
    }

    public void setSupportedContentType(MimeType supportedContentType) {
        Assert.notNull((Object)supportedContentType, (String)"'supportedContentType' cannot be null");
        this.supportedContentType = supportedContentType;
        this.supportedCTCharset = this.supportedContentType.getParameter("charset");
    }

    public void setNullAsOptionalEmpty(boolean nullAsOptionalEmpty) {
        this.nullAsOptionalEmpty = nullAsOptionalEmpty;
    }

    public @Nullable ClassMapper getClassMapper() {
        return this.classMapper;
    }

    public void setClassMapper(ClassMapper classMapper) {
        this.classMapper = classMapper;
    }

    public void setDefaultCharset(@Nullable String defaultCharset) {
        this.defaultCharset = defaultCharset != null ? Charset.forName(defaultCharset) : DEFAULT_CHARSET;
        this.charsetIsUtf8 = this.defaultCharset.equals(StandardCharsets.UTF_8);
    }

    public String getDefaultCharset() {
        return this.defaultCharset.name();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (!this.typeMapperSet) {
            ((DefaultJacksonJavaTypeMapper)this.javaTypeMapper).setBeanClassLoader(classLoader);
        }
    }

    protected @Nullable ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public JacksonJavaTypeMapper getJavaTypeMapper() {
        return this.javaTypeMapper;
    }

    public boolean isTypeMapperSet() {
        return this.typeMapperSet;
    }

    public void setJavaTypeMapper(JacksonJavaTypeMapper javaTypeMapper) {
        Assert.notNull((Object)javaTypeMapper, (String)"'javaTypeMapper' cannot be null");
        this.javaTypeMapper = javaTypeMapper;
        this.typeMapperSet = true;
    }

    public JacksonJavaTypeMapper.TypePrecedence getTypePrecedence() {
        return this.javaTypeMapper.getTypePrecedence();
    }

    public void setTypePrecedence(JacksonJavaTypeMapper.TypePrecedence typePrecedence) {
        if (this.typeMapperSet) {
            throw new IllegalStateException("When providing your own type mapper, you should set the precedence on it");
        }
        JacksonJavaTypeMapper jacksonJavaTypeMapper = this.javaTypeMapper;
        if (!(jacksonJavaTypeMapper instanceof DefaultJacksonJavaTypeMapper)) {
            throw new IllegalStateException("Type precedence is available with the DefaultJackson2JavaTypeMapper");
        }
        DefaultJacksonJavaTypeMapper defaultJacksonJavaTypeMapper = (DefaultJacksonJavaTypeMapper)jacksonJavaTypeMapper;
        defaultJacksonJavaTypeMapper.setTypePrecedence(typePrecedence);
    }

    public void setAlwaysConvertToInferredType(boolean alwaysAttemptConversion) {
        this.alwaysConvertToInferredType = alwaysAttemptConversion;
    }

    public void setAssumeSupportedContentType(boolean assumeSupportedContentType) {
        this.assumeSupportedContentType = assumeSupportedContentType;
    }

    @Override
    public Object fromMessage(Message message) throws MessageConversionException {
        return this.fromMessage(message, null);
    }

    @Override
    public Object fromMessage(Message message, @Nullable Object conversionHint) throws MessageConversionException {
        Object content = null;
        MessageProperties properties = message.getMessageProperties();
        String contentType = properties.getContentType();
        if (this.assumeSupportedContentType && contentType.equals("application/octet-stream") || contentType.contains(this.supportedContentType.getSubtype())) {
            String encoding = this.determineEncoding(properties, contentType);
            content = this.doFromMessage(message, conversionHint, properties, encoding);
        } else if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Could not convert incoming message with content-type [" + contentType + "], '" + this.supportedContentType.getSubtype() + "' keyword missing."));
        }
        if (content == null) {
            content = this.nullAsOptionalEmpty ? Optional.empty() : (Object)message.getBody();
        }
        return content;
    }

    private @Nullable String determineEncoding(MessageProperties properties, @Nullable String contentType) {
        String encoding = properties.getContentEncoding();
        if (encoding == null && contentType != null) {
            try {
                MimeType mimeType = MimeTypeUtils.parseMimeType((String)contentType);
                encoding = mimeType.getParameter("charset");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return encoding;
    }

    protected Object doFromMessage(Message message, @Nullable Object conversionHint, MessageProperties properties, @Nullable String encoding) {
        try {
            return this.convertContent(message, conversionHint, properties, encoding);
        }
        catch (IOException | JacksonException ex) {
            throw new MessageConversionException("Failed to convert Message content", ex);
        }
    }

    protected Object convertContent(Message message, @Nullable Object conversionHint, MessageProperties properties, @Nullable String encoding) throws IOException {
        Object content = null;
        JavaType inferredType = this.javaTypeMapper.getInferredType(properties);
        if (inferredType != null && this.alwaysConvertToInferredType) {
            content = this.tryConvertType(message, encoding, inferredType);
        }
        if (content == null) {
            if (conversionHint instanceof ParameterizedTypeReference) {
                ParameterizedTypeReference parameterizedTypeReference = (ParameterizedTypeReference)conversionHint;
                content = this.convertBytesToObject(message.getBody(), encoding, this.objectMapper.getTypeFactory().constructType(parameterizedTypeReference.getType()));
            } else if (this.getClassMapper() == null) {
                JavaType targetJavaType = this.getJavaTypeMapper().toJavaType(message.getMessageProperties());
                content = this.convertBytesToObject(message.getBody(), encoding, targetJavaType);
            } else {
                Class<?> targetClass = this.getClassMapper().toClass(message.getMessageProperties());
                content = this.convertBytesToObject(message.getBody(), encoding, targetClass);
            }
        }
        return content;
    }

    private @Nullable Object tryConvertType(Message message, @Nullable String encoding, JavaType inferredType) {
        try {
            return this.convertBytesToObject(message.getBody(), encoding, inferredType);
        }
        catch (Exception ex) {
            this.log.trace((Object)"Cannot create possibly abstract container contents; falling back to headers", (Throwable)ex);
            return null;
        }
    }

    private Object convertBytesToObject(byte[] body, @Nullable String encoding, Class<?> targetClass) throws IOException {
        return this.convertBytesToObject(body, encoding, this.objectMapper.constructType(targetClass));
    }

    private Object convertBytesToObject(byte[] body, @Nullable String encoding, JavaType targetJavaType) throws IOException {
        String encodingToUse = encoding;
        if (encodingToUse == null) {
            if (this.charsetIsUtf8 & this.supportedCTCharset == null) {
                return this.objectMapper.readValue(body, targetJavaType);
            }
            encodingToUse = this.getDefaultCharset();
        }
        String contentAsString = new String(body, encodingToUse);
        return this.objectMapper.readValue(contentAsString, targetJavaType);
    }

    @Override
    protected Message createMessage(Object objectToConvert, MessageProperties messageProperties) throws MessageConversionException {
        return this.createMessage(objectToConvert, messageProperties, null);
    }

    @Override
    protected Message createMessage(Object objectToConvert, MessageProperties messageProperties, @Nullable Type genericType) throws MessageConversionException {
        byte[] bytes;
        try {
            if (this.charsetIsUtf8 && this.supportedCTCharset == null) {
                bytes = this.objectMapper.writeValueAsBytes(objectToConvert);
            } else {
                String jsonString = this.objectMapper.writeValueAsString(objectToConvert);
                String encoding = this.supportedCTCharset != null ? this.supportedCTCharset : this.getDefaultCharset();
                bytes = jsonString.getBytes(encoding);
            }
        }
        catch (IOException | JacksonException ex) {
            throw new MessageConversionException("Failed to convert Message content", ex);
        }
        messageProperties.setContentType(this.supportedContentType.toString());
        if (this.supportedCTCharset == null) {
            messageProperties.setContentEncoding(this.getDefaultCharset());
        }
        messageProperties.setContentLength(bytes.length);
        if (this.getClassMapper() == null) {
            JavaType type = this.objectMapper.constructType(genericType == null ? objectToConvert.getClass() : genericType);
            if (genericType != null && !type.isContainerType() && Modifier.isAbstract(type.getRawClass().getModifiers())) {
                type = this.objectMapper.constructType(objectToConvert.getClass());
            }
            this.getJavaTypeMapper().fromJavaType(type, messageProperties);
        } else {
            this.getClassMapper().fromClass(objectToConvert.getClass(), messageProperties);
        }
        return new Message(bytes, messageProperties);
    }
}

