/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.util.Arrays;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.AbstractBuilder;
import org.springframework.amqp.core.AbstractExchange;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.HeadersExchange;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class BaseExchangeBuilder<B extends BaseExchangeBuilder<B>>
extends AbstractBuilder {
    protected final String name;
    protected final String type;
    protected boolean durable = true;
    protected boolean autoDelete;
    protected boolean internal;
    private boolean delayed;
    private boolean ignoreDeclarationExceptions;
    private boolean declare = true;
    private @Nullable Object @Nullable [] declaringAdmins;

    public BaseExchangeBuilder(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public B autoDelete() {
        this.autoDelete = true;
        return this._this();
    }

    public B durable(boolean isDurable) {
        this.durable = isDurable;
        return this._this();
    }

    public B withArgument(String key, Object value) {
        this.getOrCreateArguments().put(key, value);
        return this._this();
    }

    public B withArguments(Map<String, @Nullable Object> arguments) {
        this.getOrCreateArguments().putAll(arguments);
        return this._this();
    }

    public B alternate(String exchange) {
        return this.withArgument("alternate-exchange", exchange);
    }

    public B internal() {
        this.internal = true;
        return this._this();
    }

    public B delayed() {
        this.delayed = true;
        return this._this();
    }

    public B ignoreDeclarationExceptions() {
        this.ignoreDeclarationExceptions = true;
        return this._this();
    }

    public B suppressDeclaration() {
        this.declare = false;
        return this._this();
    }

    public B admins(Object ... admins) {
        Assert.notNull((Object)admins, (String)"'admins' cannot be null");
        Assert.noNullElements((Object[])admins, (String)"'admins' can't have null elements");
        this.declaringAdmins = Arrays.copyOf(admins, admins.length);
        return this._this();
    }

    public <T extends Exchange> T build() {
        AbstractExchange exchange = switch (this.type) {
            case "direct" -> new DirectExchange(this.name, this.durable, this.autoDelete, this.getArguments());
            case "topic" -> new TopicExchange(this.name, this.durable, this.autoDelete, this.getArguments());
            case "fanout" -> new FanoutExchange(this.name, this.durable, this.autoDelete, this.getArguments());
            case "headers" -> new HeadersExchange(this.name, this.durable, this.autoDelete, this.getArguments());
            default -> new CustomExchange(this.name, this.type, this.durable, this.autoDelete, this.getArguments());
        };
        return (T)this.configureExchange(exchange);
    }

    protected <T extends AbstractExchange> T configureExchange(T exchange) {
        exchange.setInternal(this.internal);
        exchange.setDelayed(this.delayed);
        exchange.setIgnoreDeclarationExceptions(this.ignoreDeclarationExceptions);
        exchange.setShouldDeclare(this.declare);
        if (!ObjectUtils.isEmpty((Object[])this.declaringAdmins)) {
            exchange.setAdminsThatShouldDeclare(this.declaringAdmins);
        }
        return exchange;
    }

    protected final B _this() {
        return (B)this;
    }
}

