/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.mapper.MappingException;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Type;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.Message;
import org.springframework.core.ResolvableType;
import org.springframework.data.projection.MethodInterceptorFactory;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.web.JsonProjectingMethodInterceptorFactory;
import org.springframework.util.Assert;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;

public class JacksonProjectingMessageConverter {
    private final ProjectionFactory projectionFactory;

    public JacksonProjectingMessageConverter(ObjectMapper mapper) {
        Assert.notNull((Object)mapper, (String)"'mapper' cannot be null");
        Jackson3MappingProvider provider = new Jackson3MappingProvider(mapper);
        JsonProjectingMethodInterceptorFactory interceptorFactory = new JsonProjectingMethodInterceptorFactory((MappingProvider)provider);
        SpelAwareProxyProjectionFactory factory = new SpelAwareProxyProjectionFactory();
        factory.registerMethodInvokerFactory((MethodInterceptorFactory)interceptorFactory);
        this.projectionFactory = factory;
    }

    public Object convert(Message message, Type type) {
        return this.projectionFactory.createProjection(ResolvableType.forType((Type)type).resolve(Object.class), (Object)new ByteArrayInputStream(message.getBody()));
    }

    private record Jackson3MappingProvider(ObjectMapper objectMapper) implements MappingProvider
    {
        public <T> @Nullable T map(@Nullable Object source, Class<T> targetType, Configuration configuration) {
            if (source == null) {
                return null;
            }
            try {
                return (T)this.objectMapper.convertValue(source, targetType);
            }
            catch (Exception ex) {
                throw new MappingException((Throwable)ex);
            }
        }

        public <T> @Nullable T map(@Nullable Object source, TypeRef<T> targetType, Configuration configuration) {
            if (source == null) {
                return null;
            }
            JavaType type = this.objectMapper.constructType(targetType.getType());
            try {
                return (T)this.objectMapper.convertValue(source, type);
            }
            catch (Exception ex) {
                throw new MappingException((Throwable)ex);
            }
        }
    }
}

