/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.HeadersExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.util.Assert;

public final class BindingBuilder {
    private BindingBuilder() {
    }

    public static DestinationConfigurer bind(Queue queue) {
        return new DestinationConfigurer(queue.getName(), Binding.DestinationType.QUEUE);
    }

    public static DestinationConfigurer bind(Exchange exchange) {
        return new DestinationConfigurer(exchange.getName(), Binding.DestinationType.EXCHANGE);
    }

    private static Map<String, Object> createMapForKeys(String ... keys) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : keys) {
            map.put(key, null);
        }
        return map;
    }

    public static final class DestinationConfigurer {
        protected final String name;
        protected final Binding.DestinationType type;

        DestinationConfigurer(String name, Binding.DestinationType type) {
            this.name = name;
            this.type = type;
        }

        public Binding to(FanoutExchange exchange) {
            return new Binding(this.name, this.type, exchange.getName(), "", new HashMap<String, Object>());
        }

        public HeadersExchangeMapConfigurer to(HeadersExchange exchange) {
            return new HeadersExchangeMapConfigurer(this, exchange);
        }

        public DirectExchangeRoutingKeyConfigurer to(DirectExchange exchange) {
            return new DirectExchangeRoutingKeyConfigurer(this, exchange);
        }

        public TopicExchangeRoutingKeyConfigurer to(TopicExchange exchange) {
            return new TopicExchangeRoutingKeyConfigurer(this, exchange);
        }

        public GenericExchangeRoutingKeyConfigurer to(Exchange exchange) {
            return new GenericExchangeRoutingKeyConfigurer(this, exchange);
        }
    }

    public static final class DirectExchangeRoutingKeyConfigurer
    extends AbstractRoutingKeyConfigurer {
        DirectExchangeRoutingKeyConfigurer(DestinationConfigurer destination, DirectExchange exchange) {
            super(destination, exchange.getName());
        }

        public Binding with(String routingKey) {
            return new Binding(this.destination.name, this.destination.type, this.exchange, routingKey, Collections.emptyMap());
        }

        public Binding with(Enum<?> routingKeyEnum) {
            return new Binding(this.destination.name, this.destination.type, this.exchange, routingKeyEnum.toString(), Collections.emptyMap());
        }

        public Binding withQueueName() {
            return new Binding(this.destination.name, this.destination.type, this.exchange, this.destination.name, Collections.emptyMap());
        }
    }

    public static class GenericArgumentsConfigurer {
        private final GenericExchangeRoutingKeyConfigurer configurer;
        private final String routingKey;

        public GenericArgumentsConfigurer(GenericExchangeRoutingKeyConfigurer configurer, String routingKey) {
            this.configurer = configurer;
            this.routingKey = routingKey;
        }

        public Binding and(Map<String, Object> map) {
            return new Binding(this.configurer.destination.name, this.configurer.destination.type, this.configurer.exchange, this.routingKey, map);
        }

        public Binding noargs() {
            return new Binding(this.configurer.destination.name, this.configurer.destination.type, this.configurer.exchange, this.routingKey, Collections.emptyMap());
        }
    }

    public static final class GenericExchangeRoutingKeyConfigurer
    extends AbstractRoutingKeyConfigurer {
        GenericExchangeRoutingKeyConfigurer(DestinationConfigurer destination, Exchange exchange) {
            super(destination, exchange.getName());
        }

        public GenericArgumentsConfigurer with(String routingKey) {
            return new GenericArgumentsConfigurer(this, routingKey);
        }

        public GenericArgumentsConfigurer with(Enum<?> routingKeyEnum) {
            return new GenericArgumentsConfigurer(this, routingKeyEnum.toString());
        }
    }

    public static final class TopicExchangeRoutingKeyConfigurer
    extends AbstractRoutingKeyConfigurer {
        TopicExchangeRoutingKeyConfigurer(DestinationConfigurer destination, TopicExchange exchange) {
            super(destination, exchange.getName());
        }

        public Binding with(String routingKey) {
            return new Binding(this.destination.name, this.destination.type, this.exchange, routingKey, Collections.emptyMap());
        }

        public Binding with(Enum<?> routingKeyEnum) {
            return new Binding(this.destination.name, this.destination.type, this.exchange, routingKeyEnum.toString(), Collections.emptyMap());
        }
    }

    private static abstract class AbstractRoutingKeyConfigurer {
        protected final DestinationConfigurer destination;
        protected final String exchange;

        AbstractRoutingKeyConfigurer(DestinationConfigurer destination, String exchange) {
            this.destination = destination;
            this.exchange = exchange;
        }
    }

    public static final class HeadersExchangeMapConfigurer {
        protected final DestinationConfigurer destination;
        protected final HeadersExchange exchange;

        HeadersExchangeMapConfigurer(DestinationConfigurer destination, HeadersExchange exchange) {
            this.destination = destination;
            this.exchange = exchange;
        }

        public HeadersExchangeSingleValueBindingCreator where(String key) {
            return new HeadersExchangeSingleValueBindingCreator(key);
        }

        public HeadersExchangeKeysBindingCreator whereAny(String ... headerKeys) {
            return new HeadersExchangeKeysBindingCreator(headerKeys, false);
        }

        public HeadersExchangeMapBindingCreator whereAny(Map<String, Object> headerValues) {
            return new HeadersExchangeMapBindingCreator(headerValues, false);
        }

        public HeadersExchangeKeysBindingCreator whereAll(String ... headerKeys) {
            return new HeadersExchangeKeysBindingCreator(headerKeys, true);
        }

        public HeadersExchangeMapBindingCreator whereAll(Map<String, Object> headerValues) {
            return new HeadersExchangeMapBindingCreator(headerValues, true);
        }

        public final class HeadersExchangeSingleValueBindingCreator {
            private final String key;

            HeadersExchangeSingleValueBindingCreator(String key) {
                Assert.notNull((Object)key, (String)"key must not be null");
                this.key = key;
            }

            public Binding exists() {
                return new Binding(HeadersExchangeMapConfigurer.this.destination.name, HeadersExchangeMapConfigurer.this.destination.type, HeadersExchangeMapConfigurer.this.exchange.getName(), "", BindingBuilder.createMapForKeys(this.key));
            }

            public Binding matches(Object value) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(this.key, value);
                return new Binding(HeadersExchangeMapConfigurer.this.destination.name, HeadersExchangeMapConfigurer.this.destination.type, HeadersExchangeMapConfigurer.this.exchange.getName(), "", map);
            }
        }

        public final class HeadersExchangeKeysBindingCreator {
            private final Map<String, Object> headerMap;

            HeadersExchangeKeysBindingCreator(String[] headerKeys, boolean matchAll) {
                Assert.notEmpty((Object[])headerKeys, (String)"header key list must not be empty");
                this.headerMap = BindingBuilder.createMapForKeys(headerKeys);
                this.headerMap.put("x-match", matchAll ? "all" : "any");
            }

            public Binding exist() {
                return new Binding(HeadersExchangeMapConfigurer.this.destination.name, HeadersExchangeMapConfigurer.this.destination.type, HeadersExchangeMapConfigurer.this.exchange.getName(), "", this.headerMap);
            }
        }

        public final class HeadersExchangeMapBindingCreator {
            private final Map<String, Object> headerMap;

            HeadersExchangeMapBindingCreator(Map<String, Object> headerMap, boolean matchAll) {
                Assert.notEmpty(headerMap, (String)"header map must not be empty");
                this.headerMap = new HashMap<String, Object>(headerMap);
                this.headerMap.put("x-match", matchAll ? "all" : "any");
            }

            public Binding match() {
                return new Binding(HeadersExchangeMapConfigurer.this.destination.name, HeadersExchangeMapConfigurer.this.destination.type, HeadersExchangeMapConfigurer.this.exchange.getName(), "", this.headerMap);
            }
        }
    }
}

