/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class Address {
    private static final Pattern pattern = Pattern.compile("^(?:.*://)?([^/]*)/?(.*)$");
    private final String exchangeName;
    private final String routingKey;

    public Address(String address) {
        if (!StringUtils.hasText((String)address)) {
            this.exchangeName = "";
            this.routingKey = "";
        } else if (address.lastIndexOf(47) <= 0) {
            this.routingKey = address.replaceFirst("/", "");
            this.exchangeName = "";
        } else {
            Matcher matcher = pattern.matcher(address);
            boolean matchFound = matcher.find();
            if (matchFound) {
                this.exchangeName = matcher.group(1);
                this.routingKey = matcher.group(2);
            } else {
                this.exchangeName = "";
                this.routingKey = address;
            }
        }
    }

    @Deprecated
    public Address(String exchangeType, String exchangeName, String routingKey) {
        this.exchangeName = exchangeName;
        this.routingKey = routingKey;
    }

    public Address(String exchangeName, String routingKey) {
        this.exchangeName = exchangeName;
        this.routingKey = routingKey;
    }

    @Deprecated
    public String getExchangeType() {
        return null;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.exchangeName + "/");
        if (StringUtils.hasText((String)this.routingKey)) {
            sb.append(this.routingKey);
        }
        return sb.toString();
    }
}

