/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.weaviate;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.FilterExpressionConverter;
import org.springframework.ai.vectorstore.filter.FilterHelper;
import org.springframework.ai.vectorstore.filter.converter.AbstractFilterExpressionConverter;
import org.springframework.util.Assert;

public class WeaviateFilterExpressionConverter
extends AbstractFilterExpressionConverter {
    private static final List<String> SYSTEM_IDENTIFIERS = List.of("id", "_creationTimeUnix", "_lastUpdateTimeUnix");
    private static final String DEFAULT_META_FIELD_PREFIX = "meta_";
    private boolean mapIntegerToNumberValue = true;
    private List<String> allowedIdentifierNames;
    private final String metaFieldPrefix;

    public WeaviateFilterExpressionConverter(List<String> allowedIdentifierNames) {
        this(allowedIdentifierNames, DEFAULT_META_FIELD_PREFIX);
    }

    public WeaviateFilterExpressionConverter(List<String> allowedIdentifierNames, String metaFieldPrefix) {
        Assert.notNull(allowedIdentifierNames, (String)"List can be empty but not null.");
        Assert.notNull((Object)metaFieldPrefix, (String)"metaFieldPrefix can be empty but not null.");
        this.allowedIdentifierNames = allowedIdentifierNames;
        this.metaFieldPrefix = metaFieldPrefix;
    }

    public void setAllowedIdentifierNames(List<String> allowedIdentifierNames) {
        this.allowedIdentifierNames = allowedIdentifierNames;
    }

    public void setMapIntegerToNumberValue(boolean mapIntegerToNumberValue) {
        this.mapIntegerToNumberValue = mapIntegerToNumberValue;
    }

    protected void doExpression(Filter.Expression exp, StringBuilder context) {
        if (exp.type() == Filter.ExpressionType.IN) {
            FilterHelper.expandIn((Filter.Expression)exp, (StringBuilder)context, (FilterExpressionConverter)this);
        } else if (exp.type() == Filter.ExpressionType.NIN) {
            FilterHelper.expandNin((Filter.Expression)exp, (StringBuilder)context, (FilterExpressionConverter)this);
        } else if (exp.type() == Filter.ExpressionType.AND || exp.type() == Filter.ExpressionType.OR) {
            context.append(this.getOperationSymbol(exp));
            context.append("operands:[{");
            this.convertOperand(exp.left(), context);
            context.append("},\n{");
            this.convertOperand(exp.right(), context);
            context.append("}]");
        } else {
            this.convertOperand(exp.left(), context);
            context.append(this.getOperationSymbol(exp));
            this.convertOperand(exp.right(), context);
        }
    }

    private String getOperationSymbol(Filter.Expression exp) {
        return switch (exp.type()) {
            case Filter.ExpressionType.AND -> "operator:And \n";
            case Filter.ExpressionType.OR -> "operator:Or \n";
            case Filter.ExpressionType.EQ -> "operator:Equal \n";
            case Filter.ExpressionType.NE -> "operator:NotEqual \n";
            case Filter.ExpressionType.LT -> "operator:LessThan \n";
            case Filter.ExpressionType.LTE -> "operator:LessThanEqual \n";
            case Filter.ExpressionType.GT -> "operator:GreaterThan \n";
            case Filter.ExpressionType.GTE -> "operator:GreaterThanEqual \n";
            case Filter.ExpressionType.IN -> throw new IllegalStateException("The 'IN' operator should have been transformed into chain of OR/EQ expressions.");
            case Filter.ExpressionType.NIN -> throw new IllegalStateException("The 'NIN' operator should have been transformed into chain of AND/NEQ expressions.");
            default -> throw new UnsupportedOperationException("Not supported expression type:" + String.valueOf(exp.type()));
        };
    }

    protected void doKey(Filter.Key key, StringBuilder context) {
        String identifier = this.hasOuterQuotes(key.key()) ? this.removeOuterQuotes(key.key()) : key.key();
        context.append("path:[\"" + this.withMetaPrefix(identifier) + "\"] \n");
    }

    public String withMetaPrefix(String identifier) {
        if (SYSTEM_IDENTIFIERS.contains(identifier)) {
            return identifier;
        }
        if (this.allowedIdentifierNames.contains(identifier)) {
            return this.metaFieldPrefix + identifier;
        }
        throw new IllegalArgumentException("Not allowed filter identifier name: " + identifier + ". Consider adding it to WeaviateVectorStore#filterMetadataKeys.");
    }

    protected void doValue(Filter.Value filterValue, StringBuilder context) {
        if (filterValue.value() instanceof List) {
            throw new IllegalStateException("");
        }
        this.doSingleValue(filterValue.value(), context);
    }

    protected void doSingleValue(Object value, StringBuilder context) {
        String singleValueFormat = "valueNumber:%s ";
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            if (this.mapIntegerToNumberValue) {
                context.append(String.format(singleValueFormat, i));
            } else {
                context.append(String.format("valueInt:%s ", i));
            }
        } else if (value instanceof Long) {
            Long l = (Long)value;
            if (this.mapIntegerToNumberValue) {
                context.append(String.format(singleValueFormat, l));
            } else {
                context.append(String.format("valueInt:%s ", l));
            }
        } else if (value instanceof Double) {
            Double d = (Double)value;
            context.append(String.format(singleValueFormat, d));
        } else if (value instanceof Float) {
            Float f = (Float)value;
            context.append(String.format(singleValueFormat, f));
        } else if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            context.append(String.format("valueBoolean:%s ", b));
        } else if (value instanceof String) {
            String s = (String)value;
            context.append(String.format("valueText:\"%s\" ", s));
        } else if (value instanceof Date) {
            Date date = (Date)value;
            String dateString = DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd'T'HH:mm:ssZZZZZ");
            context.append(String.format("valueDate:\"%s\" ", dateString));
        } else {
            throw new RuntimeException("Unsupported value type: " + String.valueOf(value));
        }
    }

    protected void doGroup(Filter.Group group, StringBuilder context) {
        this.convertOperand((Filter.Operand)new Filter.Expression(Filter.ExpressionType.AND, (Filter.Operand)new Filter.Expression(Filter.ExpressionType.NE, (Filter.Operand)new Filter.Key("id"), (Filter.Operand)new Filter.Value((Object)"-1")), (Filter.Operand)group.content()), context);
    }
}

