/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vertexai.embedding;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import com.google.protobuf.util.JsonFormat;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;

public abstract class VertexAiEmbeddingUtils {
    public static Value valueOf(boolean n) {
        return Value.newBuilder().setBoolValue(n).build();
    }

    public static Value valueOf(String s) {
        return Value.newBuilder().setStringValue(s).build();
    }

    public static Value valueOf(int n) {
        return Value.newBuilder().setNumberValue((double)n).build();
    }

    public static Value valueOf(Struct struct) {
        return Value.newBuilder().setStructValue(struct).build();
    }

    public static Value jsonToValue(String json) throws InvalidProtocolBufferException {
        Value.Builder builder = Value.newBuilder();
        JsonFormat.parser().merge(json, (Message.Builder)builder);
        return builder.build();
    }

    public static float[] toVector(Value value) {
        float[] floats = new float[value.getListValue().getValuesList().size()];
        int index = 0;
        for (Value v : value.getListValue().getValuesList()) {
            double d = v.getNumberValue();
            floats[index++] = Double.valueOf(d).floatValue();
        }
        return floats;
    }

    public static class VideoBuilder {
        public byte[] videoBytes;
        public String gcsUri;
        public MimeType mimeType;
        public Integer startOffsetSec;
        public Integer endOffsetSec;
        public Integer intervalSec;

        public static VideoBuilder of(MimeType mimeType) {
            Assert.notNull((Object)mimeType, (String)"MimeType must not be null");
            VideoBuilder builder = new VideoBuilder();
            builder.mimeType = mimeType;
            return builder;
        }

        public VideoBuilder videoData(Object imageData) {
            Assert.notNull((Object)imageData, (String)"Video data must not be null");
            if (imageData instanceof byte[]) {
                byte[] imageBytes = (byte[])imageData;
                return this.videoBytes(imageBytes);
            }
            if (imageData instanceof String) {
                String uri = (String)imageData;
                return this.gcsUri(uri);
            }
            throw new IllegalArgumentException("Unsupported image data type: " + String.valueOf(imageData.getClass()));
        }

        public VideoBuilder videoBytes(byte[] imageBytes) {
            Assert.notNull((Object)imageBytes, (String)"Video bytes must not be null");
            this.videoBytes = imageBytes;
            return this;
        }

        public VideoBuilder gcsUri(String gcsUri) {
            Assert.hasText((String)gcsUri, (String)"GCS URI must not be empty");
            this.gcsUri = gcsUri;
            return this;
        }

        public VideoBuilder startOffsetSec(Integer startOffsetSec) {
            if (startOffsetSec != null) {
                this.startOffsetSec = startOffsetSec;
            }
            return this;
        }

        public VideoBuilder endOffsetSec(Integer endOffsetSec) {
            if (endOffsetSec != null) {
                this.endOffsetSec = endOffsetSec;
            }
            return this;
        }

        public VideoBuilder intervalSec(Integer intervalSec) {
            if (intervalSec != null) {
                this.intervalSec = intervalSec;
            }
            return this;
        }

        public Struct build() {
            Struct.Builder videoBuilder = Struct.newBuilder();
            if (this.videoBytes != null) {
                byte[] imageData = Base64.getEncoder().encode(this.videoBytes);
                String encodedImage = new String(imageData, StandardCharsets.UTF_8);
                videoBuilder.putFields("bytesBase64Encoded", VertexAiEmbeddingUtils.valueOf(encodedImage));
            } else if (this.gcsUri != null) {
                videoBuilder.putFields("gcsUri", VertexAiEmbeddingUtils.valueOf(this.gcsUri));
            }
            if (this.mimeType != null) {
                videoBuilder.putFields("mimeType", VertexAiEmbeddingUtils.valueOf(this.mimeType.toString()));
            }
            Struct.Builder videoConfigBuilder = Struct.newBuilder();
            if (this.startOffsetSec != null) {
                videoConfigBuilder.putFields("startOffsetSec", VertexAiEmbeddingUtils.valueOf(this.startOffsetSec));
            }
            if (this.endOffsetSec != null) {
                videoConfigBuilder.putFields("endOffsetSec", VertexAiEmbeddingUtils.valueOf(this.endOffsetSec));
            }
            if (this.intervalSec != null) {
                videoConfigBuilder.putFields("intervalSec", VertexAiEmbeddingUtils.valueOf(this.intervalSec));
            }
            if (videoConfigBuilder.getFieldsCount() > 0) {
                videoBuilder.putFields("videoSegmentConfig", Value.newBuilder().setStructValue(videoConfigBuilder.build()).build());
            }
            Assert.isTrue((videoBuilder.getFieldsCount() > 0 ? 1 : 0) != 0, (String)"At least one of the videoBytes or gcsUri must be set");
            return videoBuilder.build();
        }
    }

    public static class ImageBuilder {
        public byte[] imageBytes;
        public String gcsUri;
        public MimeType mimeType;

        public static ImageBuilder of(MimeType mimeType) {
            Assert.notNull((Object)mimeType, (String)"MimeType must not be null");
            ImageBuilder builder = new ImageBuilder();
            builder.mimeType = mimeType;
            return builder;
        }

        public ImageBuilder imageData(Object imageData) {
            Assert.notNull((Object)imageData, (String)"Image data must not be null");
            if (imageData instanceof byte[]) {
                byte[] bytes = (byte[])imageData;
                return this.imageBytes(bytes);
            }
            if (imageData instanceof String) {
                String uri = (String)imageData;
                return this.gcsUri(uri);
            }
            throw new IllegalArgumentException("Unsupported image data type: " + String.valueOf(imageData.getClass()));
        }

        public ImageBuilder imageBytes(byte[] imageBytes) {
            Assert.notNull((Object)imageBytes, (String)"Image bytes must not be null");
            this.imageBytes = imageBytes;
            return this;
        }

        public ImageBuilder gcsUri(String gcsUri) {
            Assert.hasText((String)gcsUri, (String)"GCS URI must not be empty");
            this.gcsUri = gcsUri;
            return this;
        }

        public Struct build() {
            Struct.Builder imageBuilder = Struct.newBuilder();
            if (this.imageBytes != null) {
                byte[] imageData = Base64.getEncoder().encode(this.imageBytes);
                String encodedImage = new String(imageData, StandardCharsets.UTF_8);
                imageBuilder.putFields("bytesBase64Encoded", VertexAiEmbeddingUtils.valueOf(encodedImage));
            } else if (this.gcsUri != null) {
                imageBuilder.putFields("gcsUri", VertexAiEmbeddingUtils.valueOf(this.gcsUri));
            }
            if (this.mimeType != null) {
                imageBuilder.putFields("mimeType", VertexAiEmbeddingUtils.valueOf(this.mimeType.toString()));
            }
            Assert.isTrue((imageBuilder.getFieldsCount() > 0 ? 1 : 0) != 0, (String)"At least one of the imageBytes or gcsUri must be set");
            return imageBuilder.build();
        }
    }

    public static class MultimodalInstanceBuilder {
        private String text;
        private Integer dimension;
        private Struct image;
        private Struct video;

        public static MultimodalInstanceBuilder of() {
            return new MultimodalInstanceBuilder();
        }

        public MultimodalInstanceBuilder text(String text) {
            Assert.hasText((String)text, (String)"Text must not be empty");
            this.text = text;
            return this;
        }

        public MultimodalInstanceBuilder dimension(Integer dimension) {
            Assert.isTrue((dimension == 128 || dimension == 256 || dimension == 512 || dimension == 1408 ? 1 : 0) != 0, (String)("Invalid dimension value: " + dimension + ". Accepted values: 128, 256, 512, or 1408."));
            this.dimension = dimension;
            return this;
        }

        public MultimodalInstanceBuilder image(Struct image) {
            Assert.notNull((Object)image, (String)"Image must not be null");
            this.image = image;
            return this;
        }

        public MultimodalInstanceBuilder video(Struct video) {
            Assert.notNull((Object)video, (String)"Video must not be null");
            this.video = video;
            return this;
        }

        public Struct build() {
            Struct.Builder builder = Struct.newBuilder();
            if (this.text != null) {
                builder.putFields("text", VertexAiEmbeddingUtils.valueOf(this.text));
            }
            if (this.dimension != null) {
                Struct.Builder dimensionBuilder = Struct.newBuilder();
                dimensionBuilder.putFields("dimension", VertexAiEmbeddingUtils.valueOf(this.dimension));
                builder.putFields("parameters", Value.newBuilder().setStructValue(dimensionBuilder.build()).build());
            }
            if (this.image != null) {
                builder.putFields("image", Value.newBuilder().setStructValue(this.image).build());
            }
            if (this.video != null) {
                builder.putFields("video", Value.newBuilder().setStructValue(this.video).build());
            }
            Assert.isTrue((builder.getFieldsCount() > 0 ? 1 : 0) != 0, (String)"At least one of the text, image or video must be set");
            return builder.build();
        }
    }

    public static class TextInstanceBuilder {
        public String content;
        public String taskType;
        public String title;

        public static TextInstanceBuilder of(String content) {
            Assert.hasText((String)content, (String)"Content must not be empty");
            TextInstanceBuilder builder = new TextInstanceBuilder();
            builder.content = content;
            return builder;
        }

        public TextInstanceBuilder taskType(String taskType) {
            Assert.hasText((String)taskType, (String)"Task type must not be empty");
            this.taskType = taskType;
            return this;
        }

        public TextInstanceBuilder title(String title) {
            Assert.hasText((String)title, (String)"Title must not be empty");
            this.title = title;
            return this;
        }

        public Struct build() {
            Struct.Builder textBuilder = Struct.newBuilder();
            textBuilder.putFields("content", VertexAiEmbeddingUtils.valueOf(this.content));
            if (StringUtils.hasText((String)this.taskType)) {
                textBuilder.putFields("task_type", VertexAiEmbeddingUtils.valueOf(this.taskType));
            }
            if (StringUtils.hasText((String)this.title)) {
                textBuilder.putFields("title", VertexAiEmbeddingUtils.valueOf(this.title));
            }
            return textBuilder.build();
        }
    }

    public static class TextParametersBuilder {
        public Integer outputDimensionality;
        public Boolean autoTruncate;

        public static TextParametersBuilder of() {
            return new TextParametersBuilder();
        }

        public TextParametersBuilder outputDimensionality(Integer outputDimensionality) {
            Assert.notNull((Object)outputDimensionality, (String)"Output dimensionality must not be null");
            this.outputDimensionality = outputDimensionality;
            return this;
        }

        public TextParametersBuilder autoTruncate(Boolean autoTruncate) {
            Assert.notNull((Object)autoTruncate, (String)"Auto truncate must not be null");
            this.autoTruncate = autoTruncate;
            return this;
        }

        public Struct build() {
            Struct.Builder textParametersBuilder = Struct.newBuilder();
            if (this.outputDimensionality != null) {
                textParametersBuilder.putFields("outputDimensionality", VertexAiEmbeddingUtils.valueOf(this.outputDimensionality));
            }
            if (this.autoTruncate != null) {
                textParametersBuilder.putFields("autoTruncate", VertexAiEmbeddingUtils.valueOf(this.autoTruncate));
            }
            return textParametersBuilder.build();
        }
    }
}

