/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vertexai.embedding.multimodal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.vertexai.embedding.multimodal.VertexAiMultimodalEmbeddingModelName;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VertexAiMultimodalEmbeddingOptions
implements EmbeddingOptions {
    public static final String DEFAULT_MODEL_NAME = VertexAiMultimodalEmbeddingModelName.MULTIMODAL_EMBEDDING_001.getName();
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="dimensions")
    private Integer dimensions;
    @JsonProperty(value="videoStartOffsetSec")
    private Integer videoStartOffsetSec;
    @JsonProperty(value="videoEndOffsetSec")
    private Integer videoEndOffsetSec;
    @JsonProperty(value="videoIntervalSec")
    private Integer videoIntervalSec;

    public static Builder builder() {
        return new Builder();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Integer getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Integer dimensions) {
        this.dimensions = dimensions;
    }

    public Integer getVideoStartOffsetSec() {
        return this.videoStartOffsetSec;
    }

    public void setVideoStartOffsetSec(Integer videoStartOffsetSec) {
        this.videoStartOffsetSec = videoStartOffsetSec;
    }

    public Integer getVideoEndOffsetSec() {
        return this.videoEndOffsetSec;
    }

    public void setVideoEndOffsetSec(Integer videoEndOffsetSec) {
        this.videoEndOffsetSec = videoEndOffsetSec;
    }

    public Integer getVideoIntervalSec() {
        return this.videoIntervalSec;
    }

    public void setVideoIntervalSec(Integer videoIntervalSec) {
        this.videoIntervalSec = videoIntervalSec;
    }

    public static final class Builder {
        protected VertexAiMultimodalEmbeddingOptions options = new VertexAiMultimodalEmbeddingOptions();

        public Builder from(VertexAiMultimodalEmbeddingOptions fromOptions) {
            if (fromOptions.getDimensions() != null) {
                this.options.setDimensions(fromOptions.getDimensions());
            }
            if (StringUtils.hasText((String)fromOptions.getModel())) {
                this.options.setModel(fromOptions.getModel());
            }
            if (fromOptions.getVideoStartOffsetSec() != null) {
                this.options.setVideoStartOffsetSec(fromOptions.getVideoStartOffsetSec());
            }
            if (fromOptions.getVideoEndOffsetSec() != null) {
                this.options.setVideoEndOffsetSec(fromOptions.getVideoEndOffsetSec());
            }
            if (fromOptions.getVideoIntervalSec() != null) {
                this.options.setVideoIntervalSec(fromOptions.getVideoIntervalSec());
            }
            return this;
        }

        public Builder model(String model) {
            this.options.setModel(model);
            return this;
        }

        public Builder model(VertexAiMultimodalEmbeddingModelName model) {
            this.options.setModel(model.getName());
            return this;
        }

        public Builder dimensions(Integer dimensions) {
            this.options.setDimensions(dimensions);
            return this;
        }

        public Builder videoStartOffsetSec(Integer videoStartOffsetSec) {
            this.options.setVideoStartOffsetSec(videoStartOffsetSec);
            return this;
        }

        public Builder videoEndOffsetSec(Integer videoEndOffsetSec) {
            this.options.setVideoEndOffsetSec(videoEndOffsetSec);
            return this;
        }

        public Builder videoIntervalSec(Integer videoIntervalSec) {
            this.options.setVideoIntervalSec(videoIntervalSec);
            return this;
        }

        public VertexAiMultimodalEmbeddingOptions build() {
            return this.options;
        }
    }
}

