/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.evaluation;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

public class BasicEvaluationTest {
    private static final Logger logger = LoggerFactory.getLogger(BasicEvaluationTest.class);
    @Autowired
    protected ChatModel openAiChatModel;
    @Value(value="classpath:/prompts/spring/test/evaluation/qa-evaluator-accurate-answer.st")
    protected Resource qaEvaluatorAccurateAnswerResource;
    @Value(value="classpath:/prompts/spring/test/evaluation/qa-evaluator-not-related-message.st")
    protected Resource qaEvaluatorNotRelatedResource;
    @Value(value="classpath:/prompts/spring/test/evaluation/qa-evaluator-fact-based-answer.st")
    protected Resource qaEvaluatorFactBasedAnswerResource;
    @Value(value="classpath:/prompts/spring/test/evaluation/user-evaluator-message.st")
    protected Resource userEvaluatorResource;

    protected void evaluateQuestionAndAnswer(String question, String answer, boolean factBased) {
        Assertions.assertThat((String)question).isNotNull();
        Assertions.assertThat((String)answer).isNotNull();
        logger.info("Question: {}", (Object)question);
        logger.info("Answer:{}", (Object)answer);
        PromptTemplate userPromptTemplate = PromptTemplate.builder().resource(this.userEvaluatorResource).variables(Map.of("question", question, "answer", answer)).build();
        SystemMessage systemMessage = factBased ? new SystemMessage(this.qaEvaluatorFactBasedAnswerResource) : new SystemMessage(this.qaEvaluatorAccurateAnswerResource);
        Message userMessage = userPromptTemplate.createMessage();
        Prompt prompt = new Prompt(List.of(userMessage, systemMessage));
        String yesOrNo = this.openAiChatModel.call(prompt).getResult().getOutput().getText();
        logger.info("Is Answer related to question: {}", (Object)yesOrNo);
        if (yesOrNo.equalsIgnoreCase("no")) {
            SystemMessage notRelatedSystemMessage = new SystemMessage(this.qaEvaluatorNotRelatedResource);
            prompt = new Prompt(List.of(userMessage, notRelatedSystemMessage));
            String reasonForFailure = this.openAiChatModel.call(prompt).getResult().getOutput().getText();
            Assertions.fail((String)reasonForFailure);
        } else {
            logger.info("Answer is related to question.");
            Assertions.assertThat((String)yesOrNo).isEqualTo("YES");
        }
    }
}

