/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bindings;

import java.net.URI;
import java.util.Map;
import org.springframework.ai.bindings.BindingsValidator;
import org.springframework.cloud.bindings.Bindings;
import org.springframework.cloud.bindings.boot.BindingsPropertiesProcessor;
import org.springframework.core.env.Environment;

public class WeaviateBindingsPropertiesProcessor
implements BindingsPropertiesProcessor {
    public static final String TYPE = "weaviate";

    public void process(Environment environment, Bindings bindings, Map<String, Object> properties) {
        if (!BindingsValidator.isTypeEnabled(environment, TYPE)) {
            return;
        }
        bindings.filterBindings(TYPE).forEach(binding -> {
            URI uri = URI.create((String)binding.getSecret().get("uri"));
            properties.put("spring.ai.vectorstore.weaviate.scheme", uri.getScheme());
            properties.put("spring.ai.vectorstore.weaviate.host", "%s:%s".formatted(uri.getHost(), uri.getPort()));
            properties.put("spring.ai.vectorstore.weaviate.api-key", binding.getSecret().get("api-key"));
        });
    }
}

