/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.testcontainers.service.connection.chroma;

import java.util.Map;
import org.springframework.ai.vectorstore.chroma.autoconfigure.ChromaConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.chromadb.ChromaDBContainer;

class ChromaContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<ChromaDBContainer, ChromaConnectionDetails> {
    ChromaContainerConnectionDetailsFactory() {
    }

    public ChromaConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<ChromaDBContainer> source) {
        return new ChromaDBContainerConnectionDetails(source);
    }

    private static final class ChromaDBContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<ChromaDBContainer>
    implements ChromaConnectionDetails {
        private static final String CHROMA_SERVER_AUTH_CREDENTIALS = "CHROMA_SERVER_AUTH_CREDENTIALS";
        private static final String CHROMA_SERVER_AUTHN_CREDENTIALS = "CHROMA_SERVER_AUTHN_CREDENTIALS";

        private ChromaDBContainerConnectionDetails(ContainerConnectionSource<ChromaDBContainer> source) {
            super(source);
        }

        public String getHost() {
            return "http://%s".formatted(((ChromaDBContainer)this.getContainer()).getHost());
        }

        public int getPort() {
            return ((ChromaDBContainer)this.getContainer()).getMappedPort(8000);
        }

        public String getKeyToken() {
            Map envVars = ((ChromaDBContainer)this.getContainer()).getEnvMap();
            if (envVars.containsKey(CHROMA_SERVER_AUTH_CREDENTIALS)) {
                return (String)envVars.get(CHROMA_SERVER_AUTH_CREDENTIALS);
            }
            return (String)envVars.get(CHROMA_SERVER_AUTHN_CREDENTIALS);
        }
    }
}

