/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.testcontainers.service.connection.milvus;

import org.springframework.ai.autoconfigure.vectorstore.milvus.MilvusServiceClientConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.milvus.MilvusContainer;

class MilvusContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<MilvusContainer, MilvusServiceClientConnectionDetails> {
    MilvusContainerConnectionDetailsFactory() {
    }

    public MilvusServiceClientConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<MilvusContainer> source) {
        return new MilvusContainerConnectionDetails(source);
    }

    private static final class MilvusContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<MilvusContainer>
    implements MilvusServiceClientConnectionDetails {
        private MilvusContainerConnectionDetails(ContainerConnectionSource<MilvusContainer> source) {
            super(source);
        }

        public String getHost() {
            return ((MilvusContainer)this.getContainer()).getHost();
        }

        public int getPort() {
            return ((MilvusContainer)this.getContainer()).getMappedPort(19530);
        }
    }
}

