/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.docker.compose.service.connection.weaviate;

import org.springframework.ai.vectorstore.weaviate.autoconfigure.WeaviateConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

class WeaviateDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<WeaviateConnectionDetails> {
    private static final String[] WEAVIATE_IMAGE_NAMES = new String[]{"semitechnologies/weaviate", "cr.weaviate.io/semitechnologies/weaviate"};
    private static final int WEAVIATE_PORT = 8080;

    protected WeaviateDockerComposeConnectionDetailsFactory() {
        super(WEAVIATE_IMAGE_NAMES, new String[0]);
    }

    protected WeaviateConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new WeaviateDockerComposeConnectionDetails(source.getRunningService());
    }

    static class WeaviateDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements WeaviateConnectionDetails {
        private final String host;

        WeaviateDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.host = service.host() + ":" + service.ports().get(8080);
        }

        public String getHost() {
            return this.host;
        }
    }
}

