/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.pinecone;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.ai.autoconfigure.vectorstore.pinecone.PineconeVectorStoreProperties;
import org.springframework.ai.embedding.BatchingStrategy;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.TokenCountBatchingStrategy;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationConvention;
import org.springframework.ai.vectorstore.pinecone.PineconeVectorStore;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={PineconeVectorStore.class, EmbeddingModel.class})
@EnableConfigurationProperties(value={PineconeVectorStoreProperties.class})
public class PineconeVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={BatchingStrategy.class})
    BatchingStrategy batchingStrategy() {
        return new TokenCountBatchingStrategy();
    }

    @Bean
    @ConditionalOnMissingBean
    public PineconeVectorStore vectorStore(EmbeddingModel embeddingModel, PineconeVectorStoreProperties properties, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<VectorStoreObservationConvention> customObservationConvention, BatchingStrategy batchingStrategy) {
        return ((PineconeVectorStore.Builder)((PineconeVectorStore.Builder)((PineconeVectorStore.Builder)PineconeVectorStore.builder((EmbeddingModel)embeddingModel).apiKey(properties.getApiKey()).projectId(properties.getProjectId()).environment(properties.getEnvironment()).indexName(properties.getIndexName()).namespace(properties.getNamespace()).contentFieldName(properties.getContentFieldName()).distanceMetadataFieldName(properties.getDistanceMetadataFieldName()).serverSideTimeout(properties.getServerSideTimeout()).observationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP))).customObservationConvention((VectorStoreObservationConvention)customObservationConvention.getIfAvailable(() -> null))).batchingStrategy(batchingStrategy)).build();
    }
}

