/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.opensearch;

import io.micrometer.observation.ObservationRegistry;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.core5.http.HttpHost;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.aws.AwsSdk2Transport;
import org.opensearch.client.transport.aws.AwsSdk2TransportOptions;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5TransportBuilder;
import org.springframework.ai.autoconfigure.vectorstore.opensearch.AwsOpenSearchConnectionDetails;
import org.springframework.ai.autoconfigure.vectorstore.opensearch.OpenSearchConnectionDetails;
import org.springframework.ai.autoconfigure.vectorstore.opensearch.OpenSearchVectorStoreProperties;
import org.springframework.ai.embedding.BatchingStrategy;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.TokenCountBatchingStrategy;
import org.springframework.ai.vectorstore.OpenSearchVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationConvention;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;

@AutoConfiguration
@ConditionalOnClass(value={OpenSearchVectorStore.class, EmbeddingModel.class, OpenSearchClient.class})
@EnableConfigurationProperties(value={OpenSearchVectorStoreProperties.class})
public class OpenSearchVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={OpenSearchConnectionDetails.class})
    PropertiesOpenSearchConnectionDetails openSearchConnectionDetails(OpenSearchVectorStoreProperties properties) {
        return new PropertiesOpenSearchConnectionDetails(properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={BatchingStrategy.class})
    BatchingStrategy batchingStrategy() {
        return new TokenCountBatchingStrategy();
    }

    @Bean
    @ConditionalOnMissingBean
    OpenSearchVectorStore vectorStore(OpenSearchVectorStoreProperties properties, OpenSearchClient openSearchClient, EmbeddingModel embeddingModel, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<VectorStoreObservationConvention> customObservationConvention, BatchingStrategy batchingStrategy) {
        String indexName = Optional.ofNullable(properties.getIndexName()).orElse("spring-ai-document-index");
        String mappingJson = Optional.ofNullable(properties.getMappingJson()).orElse("{\n\t\"properties\":{\n\t\t\"embedding\":{\n\t\t\t\"type\":\"knn_vector\",\n\t\t\t\"dimension\":%s\n\t\t}\n\t}\n}\n");
        return new OpenSearchVectorStore(indexName, openSearchClient, embeddingModel, mappingJson, properties.isInitializeSchema(), (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP), (VectorStoreObservationConvention)customObservationConvention.getIfAvailable(() -> null), batchingStrategy);
    }

    static class PropertiesOpenSearchConnectionDetails
    implements OpenSearchConnectionDetails {
        private final OpenSearchVectorStoreProperties properties;

        PropertiesOpenSearchConnectionDetails(OpenSearchVectorStoreProperties properties) {
            this.properties = properties;
        }

        @Override
        public List<String> getUris() {
            return this.properties.getUris();
        }

        @Override
        public String getUsername() {
            return this.properties.getUsername();
        }

        @Override
        public String getPassword() {
            return this.properties.getPassword();
        }
    }

    static class PropertiesAwsOpenSearchConnectionDetails
    implements AwsOpenSearchConnectionDetails {
        private final OpenSearchVectorStoreProperties.Aws aws;

        PropertiesAwsOpenSearchConnectionDetails(OpenSearchVectorStoreProperties properties) {
            this.aws = properties.getAws();
        }

        @Override
        public String getRegion() {
            return this.aws.getRegion();
        }

        @Override
        public String getAccessKey() {
            return this.aws.getAccessKey();
        }

        @Override
        public String getSecretKey() {
            return this.aws.getSecretKey();
        }

        @Override
        public String getHost(String domainName) {
            if (StringUtils.hasText((String)domainName)) {
                return "%s.%s".formatted(this.aws.getDomainName(), this.aws.getHost());
            }
            return this.aws.getHost();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={AwsCredentialsProvider.class, Region.class, ApacheHttpClient.class})
    static class AwsOpenSearchConfiguration {
        AwsOpenSearchConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={AwsOpenSearchConnectionDetails.class})
        PropertiesAwsOpenSearchConnectionDetails awsOpenSearchConnectionDetails(OpenSearchVectorStoreProperties properties) {
            return new PropertiesAwsOpenSearchConnectionDetails(properties);
        }

        @Bean
        @ConditionalOnMissingBean
        OpenSearchClient openSearchClient(OpenSearchVectorStoreProperties properties, AwsOpenSearchConnectionDetails connectionDetails, AwsSdk2TransportOptions options) {
            Region region = Region.of((String)connectionDetails.getRegion());
            SdkHttpClient httpClient = ApacheHttpClient.builder().build();
            AwsSdk2Transport transport = new AwsSdk2Transport(httpClient, connectionDetails.getHost(properties.getAws().getDomainName()), properties.getAws().getServiceName(), region, options);
            return new OpenSearchClient((OpenSearchTransport)transport);
        }

        @Bean
        @ConditionalOnMissingBean
        AwsSdk2TransportOptions options(AwsOpenSearchConnectionDetails connectionDetails) {
            return AwsSdk2TransportOptions.builder().setCredentials((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)connectionDetails.getAccessKey(), (String)connectionDetails.getSecretKey()))).build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"software.amazon.awssdk.regions.Region", "software.amazon.awssdk.http.apache.ApacheHttpClient"})
    static class OpenSearchConfiguration {
        OpenSearchConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        OpenSearchClient openSearchClient(OpenSearchConnectionDetails connectionDetails) {
            HttpHost[] httpHosts = (HttpHost[])connectionDetails.getUris().stream().map(s -> this.createHttpHost((String)s)).toArray(HttpHost[]::new);
            ApacheHttpClient5TransportBuilder transportBuilder = ApacheHttpClient5TransportBuilder.builder((HttpHost[])httpHosts);
            Optional.ofNullable(connectionDetails.getUsername()).map(username -> this.createBasicCredentialsProvider(httpHosts[0], (String)username, connectionDetails.getPassword())).ifPresent(basicCredentialsProvider -> transportBuilder.setHttpClientConfigCallback(httpAsyncClientBuilder -> httpAsyncClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider)));
            return new OpenSearchClient((OpenSearchTransport)transportBuilder.build());
        }

        private BasicCredentialsProvider createBasicCredentialsProvider(HttpHost httpHost, String username, String password) {
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(new AuthScope(httpHost), (Credentials)new UsernamePasswordCredentials(username, password.toCharArray()));
            return basicCredentialsProvider;
        }

        private HttpHost createHttpHost(String s) {
            try {
                return HttpHost.create((String)s);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

