/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.ollama;

import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import org.springframework.ai.autoconfigure.ollama.OllamaChatProperties;
import org.springframework.ai.autoconfigure.ollama.OllamaConnectionDetails;
import org.springframework.ai.autoconfigure.ollama.OllamaConnectionProperties;
import org.springframework.ai.autoconfigure.ollama.OllamaEmbeddingProperties;
import org.springframework.ai.autoconfigure.ollama.OllamaInitializationProperties;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackContext;
import org.springframework.ai.ollama.OllamaChatModel;
import org.springframework.ai.ollama.OllamaEmbeddingModel;
import org.springframework.ai.ollama.api.OllamaApi;
import org.springframework.ai.ollama.management.ModelManagementOptions;
import org.springframework.ai.ollama.management.PullModelStrategy;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class})
@ConditionalOnClass(value={OllamaApi.class})
@EnableConfigurationProperties(value={OllamaChatProperties.class, OllamaEmbeddingProperties.class, OllamaConnectionProperties.class, OllamaInitializationProperties.class})
@ImportAutoConfiguration(classes={RestClientAutoConfiguration.class, WebClientAutoConfiguration.class})
public class OllamaAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={OllamaConnectionDetails.class})
    public PropertiesOllamaConnectionDetails ollamaConnectionDetails(OllamaConnectionProperties properties) {
        return new PropertiesOllamaConnectionDetails(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public OllamaApi ollamaApi(OllamaConnectionDetails connectionDetails, ObjectProvider<RestClient.Builder> restClientBuilderProvider, ObjectProvider<WebClient.Builder> webClientBuilderProvider) {
        return new OllamaApi(connectionDetails.getBaseUrl(), (RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder), (WebClient.Builder)webClientBuilderProvider.getIfAvailable(WebClient::builder));
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.ollama.chat", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public OllamaChatModel ollamaChatModel(OllamaApi ollamaApi, OllamaChatProperties properties, OllamaInitializationProperties initProperties, List<FunctionCallback> toolFunctionCallbacks, FunctionCallbackContext functionCallbackContext, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ChatModelObservationConvention> observationConvention) {
        PullModelStrategy chatModelPullStrategy = initProperties.getChat().isInclude() ? initProperties.getPullModelStrategy() : PullModelStrategy.NEVER;
        OllamaChatModel chatModel = OllamaChatModel.builder().withOllamaApi(ollamaApi).withDefaultOptions(properties.getOptions()).withFunctionCallbackContext(functionCallbackContext).withToolFunctionCallbacks(toolFunctionCallbacks).withObservationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP)).withModelManagementOptions(new ModelManagementOptions(chatModelPullStrategy, initProperties.getChat().getAdditionalModels(), initProperties.getTimeout(), Integer.valueOf(initProperties.getMaxRetries()))).build();
        observationConvention.ifAvailable(arg_0 -> ((OllamaChatModel)chatModel).setObservationConvention(arg_0));
        return chatModel;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.ollama.embedding", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public OllamaEmbeddingModel ollamaEmbeddingModel(OllamaApi ollamaApi, OllamaEmbeddingProperties properties, OllamaInitializationProperties initProperties, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<EmbeddingModelObservationConvention> observationConvention) {
        PullModelStrategy embeddingModelPullStrategy = initProperties.getEmbedding().isInclude() ? initProperties.getPullModelStrategy() : PullModelStrategy.NEVER;
        OllamaEmbeddingModel embeddingModel = OllamaEmbeddingModel.builder().withOllamaApi(ollamaApi).withDefaultOptions(properties.getOptions()).withObservationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP)).withModelManagementOptions(new ModelManagementOptions(embeddingModelPullStrategy, initProperties.getEmbedding().getAdditionalModels(), initProperties.getTimeout(), Integer.valueOf(initProperties.getMaxRetries()))).build();
        observationConvention.ifAvailable(arg_0 -> ((OllamaEmbeddingModel)embeddingModel).setObservationConvention(arg_0));
        return embeddingModel;
    }

    @Bean
    @ConditionalOnMissingBean
    public FunctionCallbackContext springAiFunctionManager(ApplicationContext context) {
        FunctionCallbackContext manager = new FunctionCallbackContext();
        manager.setApplicationContext(context);
        return manager;
    }

    static class PropertiesOllamaConnectionDetails
    implements OllamaConnectionDetails {
        private final OllamaConnectionProperties properties;

        PropertiesOllamaConnectionDetails(OllamaConnectionProperties properties) {
            this.properties = properties;
        }

        @Override
        public String getBaseUrl() {
            return this.properties.getBaseUrl();
        }
    }
}

