/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vertexai.gemini;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.vertexai.Transport;
import com.google.cloud.vertexai.VertexAI;
import io.micrometer.observation.ObservationRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.springframework.ai.autoconfigure.retry.SpringAiRetryAutoConfiguration;
import org.springframework.ai.autoconfigure.vertexai.gemini.VertexAiGeminiChatProperties;
import org.springframework.ai.autoconfigure.vertexai.gemini.VertexAiGeminiConnectionProperties;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackContext;
import org.springframework.ai.vertexai.gemini.VertexAiGeminiChatModel;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={SpringAiRetryAutoConfiguration.class})
@ConditionalOnClass(value={VertexAI.class, VertexAiGeminiChatModel.class})
@EnableConfigurationProperties(value={VertexAiGeminiChatProperties.class, VertexAiGeminiConnectionProperties.class})
@ImportAutoConfiguration(classes={SpringAiRetryAutoConfiguration.class})
public class VertexAiGeminiAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public VertexAI vertexAi(VertexAiGeminiConnectionProperties connectionProperties) throws IOException {
        Assert.hasText((String)connectionProperties.getProjectId(), (String)"Vertex AI project-id must be set!");
        Assert.hasText((String)connectionProperties.getLocation(), (String)"Vertex AI location must be set!");
        Assert.notNull((Object)((Object)connectionProperties.getTransport()), (String)"Vertex AI transport must be set!");
        VertexAI.Builder vertexAIBuilder = new VertexAI.Builder().setProjectId(connectionProperties.getProjectId()).setLocation(connectionProperties.getLocation()).setTransport(Transport.valueOf((String)connectionProperties.getTransport().name()));
        if (StringUtils.hasText((String)connectionProperties.getApiEndpoint())) {
            vertexAIBuilder.setApiEndpoint(connectionProperties.getApiEndpoint());
        }
        if (!CollectionUtils.isEmpty(connectionProperties.getScopes())) {
            vertexAIBuilder.setScopes(connectionProperties.getScopes());
        }
        if (connectionProperties.getCredentialsUri() != null) {
            GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)connectionProperties.getCredentialsUri().getInputStream());
            vertexAIBuilder.setCredentials((Credentials)credentials);
        }
        return vertexAIBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.vertex.ai.gemini.chat", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public VertexAiGeminiChatModel vertexAiGeminiChat(VertexAI vertexAi, VertexAiGeminiChatProperties chatProperties, List<FunctionCallback> toolFunctionCallbacks, ApplicationContext context, RetryTemplate retryTemplate, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ChatModelObservationConvention> observationConvention) {
        FunctionCallbackContext functionCallbackContext = this.springAiFunctionManager(context);
        VertexAiGeminiChatModel chatModel = new VertexAiGeminiChatModel(vertexAi, chatProperties.getOptions(), functionCallbackContext, toolFunctionCallbacks, retryTemplate, (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
        observationConvention.ifAvailable(arg_0 -> ((VertexAiGeminiChatModel)chatModel).setObservationConvention(arg_0));
        return chatModel;
    }

    private FunctionCallbackContext springAiFunctionManager(ApplicationContext context) {
        FunctionCallbackContext manager = new FunctionCallbackContext();
        manager.setSchemaType(FunctionCallbackContext.SchemaType.OPEN_API_SCHEMA);
        manager.setApplicationContext(context);
        return manager;
    }
}

