/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.pgvector;

import io.micrometer.observation.ObservationRegistry;
import javax.sql.DataSource;
import org.springframework.ai.autoconfigure.vectorstore.pgvector.PgVectorStoreProperties;
import org.springframework.ai.embedding.BatchingStrategy;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.TokenCountBatchingStrategy;
import org.springframework.ai.vectorstore.PgVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationConvention;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;

@AutoConfiguration(after={JdbcTemplateAutoConfiguration.class})
@ConditionalOnClass(value={PgVectorStore.class, DataSource.class, JdbcTemplate.class})
@EnableConfigurationProperties(value={PgVectorStoreProperties.class})
public class PgVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={BatchingStrategy.class})
    BatchingStrategy pgVectorStoreBatchingStrategy() {
        return new TokenCountBatchingStrategy();
    }

    @Bean
    @ConditionalOnMissingBean
    public PgVectorStore vectorStore(JdbcTemplate jdbcTemplate, EmbeddingModel embeddingModel, PgVectorStoreProperties properties, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<VectorStoreObservationConvention> customObservationConvention, BatchingStrategy batchingStrategy) {
        boolean initializeSchema = properties.isInitializeSchema();
        return new PgVectorStore.Builder(jdbcTemplate, embeddingModel).withSchemaName(properties.getSchemaName()).withVectorTableName(properties.getTableName()).withVectorTableValidationsEnabled(properties.isSchemaValidation()).withDimensions(properties.getDimensions()).withDistanceType(properties.getDistanceType()).withRemoveExistingVectorStoreTable(properties.isRemoveExistingVectorStoreTable()).withIndexType(properties.getIndexType()).withInitializeSchema(initializeSchema).withObservationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP)).withSearchObservationConvention((VectorStoreObservationConvention)customObservationConvention.getIfAvailable(() -> null)).withBatchingStrategy(batchingStrategy).withMaxDocumentBatchSize(properties.getMaxDocumentBatchSize()).build();
    }
}

