/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.chat.memory.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import org.springframework.ai.autoconfigure.chat.memory.cassandra.CassandraChatMemoryProperties;
import org.springframework.ai.chat.memory.CassandraChatMemory;
import org.springframework.ai.chat.memory.CassandraChatMemoryConfig;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.cassandra.CassandraAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={CassandraAutoConfiguration.class})
@ConditionalOnClass(value={CassandraChatMemory.class, CqlSession.class})
@EnableConfigurationProperties(value={CassandraChatMemoryProperties.class})
public class CassandraChatMemoryAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public CassandraChatMemory chatMemory(CassandraChatMemoryProperties properties, CqlSession cqlSession) {
        CassandraChatMemoryConfig.Builder builder = CassandraChatMemoryConfig.builder().withCqlSession(cqlSession);
        builder = builder.withKeyspaceName(properties.getKeyspace()).withTableName(properties.getTable()).withAssistantColumnName(properties.getAssistantColumn()).withUserColumnName(properties.getUserColumn());
        if (!properties.isInitializeSchema()) {
            builder = builder.disallowSchemaChanges();
        }
        if (null != properties.getTimeToLiveSeconds()) {
            builder = builder.withTimeToLive(properties.getTimeToLiveSeconds());
        }
        return CassandraChatMemory.create((CassandraChatMemoryConfig)builder.build());
    }
}

