/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.azure.openai;

import org.springframework.ai.azure.openai.AzureOpenAiEmbeddingOptions;
import org.springframework.ai.document.MetadataMode;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.Assert;

@ConfigurationProperties(value="spring.ai.azure.openai.embedding")
public class AzureOpenAiEmbeddingProperties {
    public static final String CONFIG_PREFIX = "spring.ai.azure.openai.embedding";
    private boolean enabled = true;
    @NestedConfigurationProperty
    private AzureOpenAiEmbeddingOptions options = AzureOpenAiEmbeddingOptions.builder().withDeploymentName("text-embedding-ada-002").build();
    private MetadataMode metadataMode = MetadataMode.EMBED;

    public AzureOpenAiEmbeddingOptions getOptions() {
        return this.options;
    }

    public void setOptions(AzureOpenAiEmbeddingOptions options) {
        Assert.notNull((Object)options, (String)"Options must not be null");
        this.options = options;
    }

    public MetadataMode getMetadataMode() {
        return this.metadataMode;
    }

    public void setMetadataMode(MetadataMode metadataMode) {
        Assert.notNull((Object)metadataMode, (String)"Metadata mode must not be null");
        this.metadataMode = metadataMode;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

