/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.pinecone;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.ai.autoconfigure.vectorstore.pinecone.PineconeVectorStoreProperties;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.vectorstore.PineconeVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationConvention;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={PineconeVectorStore.class, EmbeddingModel.class})
@EnableConfigurationProperties(value={PineconeVectorStoreProperties.class})
public class PineconeVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public PineconeVectorStore vectorStore(EmbeddingModel embeddingModel, PineconeVectorStoreProperties properties, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<VectorStoreObservationConvention> customObservationConvention) {
        PineconeVectorStore.PineconeVectorStoreConfig config = PineconeVectorStore.PineconeVectorStoreConfig.builder().withApiKey(properties.getApiKey()).withEnvironment(properties.getEnvironment()).withProjectId(properties.getProjectId()).withIndexName(properties.getIndexName()).withNamespace(properties.getNamespace()).withContentFieldName(properties.getContentFieldName()).withDistanceMetadataFieldName(properties.getDistanceMetadataFieldName()).withServerSideTimeout(properties.getServerSideTimeout()).build();
        return new PineconeVectorStore(config, embeddingModel, (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP), (VectorStoreObservationConvention)customObservationConvention.getIfAvailable(() -> null));
    }
}

