/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.qianfan;

import org.springframework.ai.autoconfigure.qianfan.QianFanChatProperties;
import org.springframework.ai.autoconfigure.qianfan.QianFanConnectionProperties;
import org.springframework.ai.autoconfigure.qianfan.QianFanEmbeddingProperties;
import org.springframework.ai.autoconfigure.qianfan.QianFanImageProperties;
import org.springframework.ai.autoconfigure.retry.SpringAiRetryAutoConfiguration;
import org.springframework.ai.model.function.FunctionCallbackContext;
import org.springframework.ai.qianfan.QianFanChatModel;
import org.springframework.ai.qianfan.QianFanEmbeddingModel;
import org.springframework.ai.qianfan.QianFanImageModel;
import org.springframework.ai.qianfan.api.QianFanApi;
import org.springframework.ai.qianfan.api.QianFanImageApi;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class, SpringAiRetryAutoConfiguration.class})
@ConditionalOnClass(value={QianFanApi.class})
@EnableConfigurationProperties(value={QianFanConnectionProperties.class, QianFanChatProperties.class, QianFanEmbeddingProperties.class, QianFanImageProperties.class})
public class QianFanAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.qianfan.chat", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public QianFanChatModel qianFanChatModel(QianFanConnectionProperties commonProperties, QianFanChatProperties chatProperties, RestClient.Builder restClientBuilder, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler) {
        QianFanApi qianFanApi = this.qianFanApi(chatProperties.getBaseUrl(), commonProperties.getBaseUrl(), chatProperties.getApiKey(), commonProperties.getApiKey(), chatProperties.getSecretKey(), commonProperties.getSecretKey(), restClientBuilder, responseErrorHandler);
        return new QianFanChatModel(qianFanApi, chatProperties.getOptions(), retryTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.qianfan.embedding", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public QianFanEmbeddingModel qianFanEmbeddingModel(QianFanConnectionProperties commonProperties, QianFanEmbeddingProperties embeddingProperties, RestClient.Builder restClientBuilder, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler) {
        QianFanApi qianFanApi = this.qianFanApi(embeddingProperties.getBaseUrl(), commonProperties.getBaseUrl(), embeddingProperties.getApiKey(), commonProperties.getApiKey(), embeddingProperties.getSecretKey(), commonProperties.getSecretKey(), restClientBuilder, responseErrorHandler);
        return new QianFanEmbeddingModel(qianFanApi, embeddingProperties.getMetadataMode(), embeddingProperties.getOptions(), retryTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.qianfan.image", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public QianFanImageModel qianFanImageModel(QianFanConnectionProperties commonProperties, QianFanImageProperties imageProperties, RestClient.Builder restClientBuilder, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler) {
        String apiKey = StringUtils.hasText((String)imageProperties.getApiKey()) ? imageProperties.getApiKey() : commonProperties.getApiKey();
        String secretKey = StringUtils.hasText((String)imageProperties.getSecretKey()) ? imageProperties.getSecretKey() : commonProperties.getSecretKey();
        String baseUrl = StringUtils.hasText((String)imageProperties.getBaseUrl()) ? imageProperties.getBaseUrl() : commonProperties.getBaseUrl();
        Assert.hasText((String)apiKey, (String)"QianFan API key must be set.  Use the property: spring.ai.qianfan.api-key");
        Assert.hasText((String)secretKey, (String)"QianFan secret key must be set.  Use the property: spring.ai.qianfan.secret-key");
        Assert.hasText((String)baseUrl, (String)"QianFan base URL must be set.  Use the property: spring.ai.qianfan.base-url");
        QianFanImageApi qianFanImageApi = new QianFanImageApi(baseUrl, apiKey, secretKey, restClientBuilder, responseErrorHandler);
        return new QianFanImageModel(qianFanImageApi, imageProperties.getOptions(), retryTemplate);
    }

    private QianFanApi qianFanApi(String baseUrl, String commonBaseUrl, String apiKey, String commonApiKey, String secretKey, String commonSecretKey, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        String resolvedBaseUrl = StringUtils.hasText((String)baseUrl) ? baseUrl : commonBaseUrl;
        Assert.hasText((String)resolvedBaseUrl, (String)"QianFan base URL must be set");
        String resolvedApiKey = StringUtils.hasText((String)apiKey) ? apiKey : commonApiKey;
        Assert.hasText((String)resolvedApiKey, (String)"QianFan API key must be set");
        String resolvedSecretKey = StringUtils.hasText((String)secretKey) ? secretKey : commonSecretKey;
        Assert.hasText((String)resolvedSecretKey, (String)"QianFan Secret key must be set");
        return new QianFanApi(resolvedBaseUrl, resolvedApiKey, resolvedSecretKey, restClientBuilder, responseErrorHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    public FunctionCallbackContext springAiFunctionManager(ApplicationContext context) {
        FunctionCallbackContext manager = new FunctionCallbackContext();
        manager.setApplicationContext(context);
        return manager;
    }
}

