/*
 * Copyright 2023-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.ai.autoconfigure.vectorstore.typesense;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author Pablo Sanchidrian Herrera
 */
@ConfigurationProperties(TypesenseServiceClientProperties.CONFIG_PREFIX)
public class TypesenseServiceClientProperties {

	public static final String CONFIG_PREFIX = "spring.ai.vectorstore.typesense.client";

	private String protocol = "http";

	private String host = "localhost";

	private int port = 8108;

	/**
	 * Typesense API key. This is the default api key when the user follows the Typesense
	 * quick start guide.
	 */
	private String apiKey = "xyz";

	public String getProtocol() {
		return protocol;
	}

	public void setProtocol(String protocol) {
		this.protocol = protocol;
	}

	public String getHost() {
		return host;
	}

	public void setHost(String host) {
		this.host = host;
	}

	public int getPort() {
		return port;
	}

	public void setPort(int port) {
		this.port = port;
	}

	public String getApiKey() {
		return apiKey;
	}

	public void setApiKey(String apiKey) {
		this.apiKey = apiKey;
	}

}
