/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.qdrant;

import io.qdrant.client.QdrantClient;
import io.qdrant.client.QdrantGrpcClient;
import org.springframework.ai.autoconfigure.vectorstore.qdrant.QdrantConnectionDetails;
import org.springframework.ai.autoconfigure.vectorstore.qdrant.QdrantVectorStoreProperties;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.vectorstore.qdrant.QdrantVectorStore;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={QdrantVectorStore.class, EmbeddingModel.class})
@EnableConfigurationProperties(value={QdrantVectorStoreProperties.class})
public class QdrantVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={QdrantConnectionDetails.class})
    PropertiesQdrantConnectionDetails qdrantConnectionDetails(QdrantVectorStoreProperties properties) {
        return new PropertiesQdrantConnectionDetails(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public QdrantClient qdrantClient(QdrantVectorStoreProperties properties, QdrantConnectionDetails connectionDetails) {
        QdrantGrpcClient.Builder grpcClientBuilder = QdrantGrpcClient.newBuilder((String)connectionDetails.getHost(), (int)connectionDetails.getPort(), (boolean)properties.isUseTls());
        if (properties.getApiKey() != null) {
            grpcClientBuilder.withApiKey(properties.getApiKey());
        }
        return new QdrantClient(grpcClientBuilder.build());
    }

    @Bean
    @ConditionalOnMissingBean
    public QdrantVectorStore vectorStore(EmbeddingModel embeddingModel, QdrantVectorStoreProperties properties, QdrantClient qdrantClient) {
        return new QdrantVectorStore(qdrantClient, properties.getCollectionName(), embeddingModel, properties.isInitializeSchema());
    }

    static class PropertiesQdrantConnectionDetails
    implements QdrantConnectionDetails {
        private final QdrantVectorStoreProperties properties;

        PropertiesQdrantConnectionDetails(QdrantVectorStoreProperties properties) {
            this.properties = properties;
        }

        @Override
        public String getHost() {
            return this.properties.getHost();
        }

        @Override
        public int getPort() {
            return this.properties.getPort();
        }
    }
}

