/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.elasticsearch;

import org.elasticsearch.client.RestClient;
import org.springframework.ai.autoconfigure.vectorstore.elasticsearch.ElasticsearchVectorStoreProperties;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.vectorstore.ElasticsearchVectorStore;
import org.springframework.ai.vectorstore.ElasticsearchVectorStoreOptions;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchRestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={ElasticsearchRestClientAutoConfiguration.class})
@ConditionalOnClass(value={ElasticsearchVectorStore.class, EmbeddingModel.class, RestClient.class})
@EnableConfigurationProperties(value={ElasticsearchVectorStoreProperties.class})
class ElasticsearchVectorStoreAutoConfiguration {
    ElasticsearchVectorStoreAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    ElasticsearchVectorStore vectorStore(ElasticsearchVectorStoreProperties properties, RestClient restClient, EmbeddingModel embeddingModel) {
        ElasticsearchVectorStoreOptions elasticsearchVectorStoreOptions = new ElasticsearchVectorStoreOptions();
        if (StringUtils.hasText((String)properties.getIndexName())) {
            elasticsearchVectorStoreOptions.setIndexName(properties.getIndexName());
        }
        if (properties.getDimensions() != null) {
            elasticsearchVectorStoreOptions.setDimensions(properties.getDimensions().intValue());
        }
        if (properties.isDenseVectorIndexing() != null) {
            elasticsearchVectorStoreOptions.setDenseVectorIndexing(properties.isDenseVectorIndexing().booleanValue());
        }
        if (StringUtils.hasText((String)properties.getSimilarity())) {
            elasticsearchVectorStoreOptions.setSimilarity(properties.getSimilarity());
        }
        return new ElasticsearchVectorStore(elasticsearchVectorStoreOptions, restClient, embeddingModel, properties.isInitializeSchema());
    }
}

