/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.cassandra;

import com.google.api.client.util.Preconditions;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.ai.vectorstore.cassandra")
public class CassandraVectorStoreProperties {
    public static final String CONFIG_PREFIX = "spring.ai.vectorstore.cassandra";
    private String keyspace = "springframework";
    private String table = "ai_vector_store";
    private String indexName = null;
    private String contentColumnName = "content";
    private String embeddingColumnName = "embedding";
    private boolean disallowSchemaChanges = false;
    private boolean returnEmbeddings = false;
    private int fixedThreadPoolExecutorSize = 16;

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getContentColumnName() {
        return this.contentColumnName;
    }

    public void setContentColumnName(String contentColumnName) {
        this.contentColumnName = contentColumnName;
    }

    public String getEmbeddingColumnName() {
        return this.embeddingColumnName;
    }

    public void setEmbeddingColumnName(String embeddingColumnName) {
        this.embeddingColumnName = embeddingColumnName;
    }

    public boolean getDisallowSchemaCreation() {
        return this.disallowSchemaChanges;
    }

    public void setDisallowSchemaCreation(boolean disallowSchemaCreation) {
        this.disallowSchemaChanges = disallowSchemaCreation;
    }

    public boolean getReturnEmbeddings() {
        return this.returnEmbeddings;
    }

    public void setReturnEmbeddings(boolean returnEmbeddings) {
        this.returnEmbeddings = returnEmbeddings;
    }

    public int getFixedThreadPoolExecutorSize() {
        return this.fixedThreadPoolExecutorSize;
    }

    public void setFixedThreadPoolExecutorSize(int fixedThreadPoolExecutorSize) {
        Preconditions.checkArgument((0 < fixedThreadPoolExecutorSize ? 1 : 0) != 0);
        this.fixedThreadPoolExecutorSize = fixedThreadPoolExecutorSize;
    }
}

