/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.mistralai;

import java.util.List;
import org.springframework.ai.autoconfigure.mistralai.MistralAiChatProperties;
import org.springframework.ai.autoconfigure.mistralai.MistralAiCommonProperties;
import org.springframework.ai.autoconfigure.mistralai.MistralAiEmbeddingProperties;
import org.springframework.ai.autoconfigure.retry.SpringAiRetryAutoConfiguration;
import org.springframework.ai.mistralai.MistralAiChatModel;
import org.springframework.ai.mistralai.MistralAiEmbeddingModel;
import org.springframework.ai.mistralai.api.MistralAiApi;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackContext;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class, SpringAiRetryAutoConfiguration.class})
@EnableConfigurationProperties(value={MistralAiEmbeddingProperties.class, MistralAiCommonProperties.class, MistralAiChatProperties.class})
@ConditionalOnClass(value={MistralAiApi.class})
public class MistralAiAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.mistralai.embedding", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public MistralAiEmbeddingModel mistralAiEmbeddingModel(MistralAiCommonProperties commonProperties, MistralAiEmbeddingProperties embeddingProperties, RestClient.Builder restClientBuilder, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler) {
        MistralAiApi mistralAiApi = this.mistralAiApi(embeddingProperties.getApiKey(), commonProperties.getApiKey(), embeddingProperties.getBaseUrl(), commonProperties.getBaseUrl(), restClientBuilder, responseErrorHandler);
        return new MistralAiEmbeddingModel(mistralAiApi, embeddingProperties.getMetadataMode(), embeddingProperties.getOptions(), retryTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.mistralai.chat", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public MistralAiChatModel mistralAiChatModel(MistralAiCommonProperties commonProperties, MistralAiChatProperties chatProperties, RestClient.Builder restClientBuilder, List<FunctionCallback> toolFunctionCallbacks, FunctionCallbackContext functionCallbackContext, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler) {
        MistralAiApi mistralAiApi = this.mistralAiApi(chatProperties.getApiKey(), commonProperties.getApiKey(), chatProperties.getBaseUrl(), commonProperties.getBaseUrl(), restClientBuilder, responseErrorHandler);
        if (!CollectionUtils.isEmpty(toolFunctionCallbacks)) {
            chatProperties.getOptions().getFunctionCallbacks().addAll(toolFunctionCallbacks);
        }
        return new MistralAiChatModel(mistralAiApi, chatProperties.getOptions(), functionCallbackContext, retryTemplate);
    }

    private MistralAiApi mistralAiApi(String apiKey, String commonApiKey, String baseUrl, String commonBaseUrl, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        String resolvedApiKey = StringUtils.hasText((String)apiKey) ? apiKey : commonApiKey;
        String resoledBaseUrl = StringUtils.hasText((String)baseUrl) ? baseUrl : commonBaseUrl;
        Assert.hasText((String)resolvedApiKey, (String)"Mistral API key must be set");
        Assert.hasText((String)resoledBaseUrl, (String)"Mistral base URL must be set");
        return new MistralAiApi(resoledBaseUrl, resolvedApiKey, restClientBuilder, responseErrorHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    public FunctionCallbackContext springAiFunctionManager(ApplicationContext context) {
        FunctionCallbackContext manager = new FunctionCallbackContext();
        manager.setApplicationContext(context);
        return manager;
    }
}

