/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.bedrock.titan;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.ai.autoconfigure.bedrock.BedrockAwsConnectionConfiguration;
import org.springframework.ai.autoconfigure.bedrock.BedrockAwsConnectionProperties;
import org.springframework.ai.autoconfigure.bedrock.titan.BedrockTitanChatProperties;
import org.springframework.ai.bedrock.titan.BedrockTitanChatModel;
import org.springframework.ai.bedrock.titan.api.TitanChatBedrockApi;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;

@AutoConfiguration
@ConditionalOnClass(value={TitanChatBedrockApi.class})
@EnableConfigurationProperties(value={BedrockTitanChatProperties.class, BedrockAwsConnectionProperties.class})
@ConditionalOnProperty(prefix="spring.ai.bedrock.titan.chat", name={"enabled"}, havingValue="true")
@Import(value={BedrockAwsConnectionConfiguration.class})
public class BedrockTitanChatAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={AwsCredentialsProvider.class, AwsRegionProvider.class})
    public TitanChatBedrockApi titanChatBedrockApi(AwsCredentialsProvider credentialsProvider, AwsRegionProvider regionProvider, BedrockTitanChatProperties properties, BedrockAwsConnectionProperties awsProperties) {
        return new TitanChatBedrockApi(properties.getModel(), credentialsProvider, regionProvider.getRegion(), new ObjectMapper(), awsProperties.getTimeout());
    }

    @Bean
    @ConditionalOnBean(value={TitanChatBedrockApi.class})
    public BedrockTitanChatModel titanChatModel(TitanChatBedrockApi titanChatApi, BedrockTitanChatProperties properties) {
        return new BedrockTitanChatModel(titanChatApi, properties.getOptions());
    }
}

