/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.azure.openai;

import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.KeyCredential;
import com.azure.core.util.ClientOptions;
import java.util.List;
import org.springframework.ai.autoconfigure.azure.openai.AzureOpenAiChatProperties;
import org.springframework.ai.autoconfigure.azure.openai.AzureOpenAiConnectionProperties;
import org.springframework.ai.autoconfigure.azure.openai.AzureOpenAiEmbeddingProperties;
import org.springframework.ai.autoconfigure.azure.openai.AzureOpenAiImageOptionsProperties;
import org.springframework.ai.azure.openai.AzureOpenAiChatModel;
import org.springframework.ai.azure.openai.AzureOpenAiEmbeddingModel;
import org.springframework.ai.azure.openai.AzureOpenAiImageModel;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackContext;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@AutoConfiguration
@ConditionalOnClass(value={OpenAIClientBuilder.class, AzureOpenAiChatModel.class})
@EnableConfigurationProperties(value={AzureOpenAiChatProperties.class, AzureOpenAiEmbeddingProperties.class, AzureOpenAiConnectionProperties.class, AzureOpenAiImageOptionsProperties.class})
public class AzureOpenAiAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public OpenAIClient openAIClient(AzureOpenAiConnectionProperties connectionProperties) {
        Assert.hasText((String)connectionProperties.getApiKey(), (String)"API key must not be empty");
        Assert.hasText((String)connectionProperties.getEndpoint(), (String)"Endpoint must not be empty");
        return new OpenAIClientBuilder().endpoint(connectionProperties.getEndpoint()).credential((KeyCredential)new AzureKeyCredential(connectionProperties.getApiKey())).clientOptions(new ClientOptions().setApplicationId("spring-ai")).buildClient();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.azure.openai.chat", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public AzureOpenAiChatModel azureOpenAiChatModel(OpenAIClient openAIClient, AzureOpenAiChatProperties chatProperties, List<FunctionCallback> toolFunctionCallbacks, FunctionCallbackContext functionCallbackContext) {
        if (!CollectionUtils.isEmpty(toolFunctionCallbacks)) {
            chatProperties.getOptions().getFunctionCallbacks().addAll(toolFunctionCallbacks);
        }
        AzureOpenAiChatModel azureOpenAiChatModel = new AzureOpenAiChatModel(openAIClient, chatProperties.getOptions(), functionCallbackContext);
        return azureOpenAiChatModel;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.azure.openai.embedding", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public AzureOpenAiEmbeddingModel azureOpenAiEmbeddingModel(OpenAIClient openAIClient, AzureOpenAiEmbeddingProperties embeddingProperties) {
        return new AzureOpenAiEmbeddingModel(openAIClient, embeddingProperties.getMetadataMode(), embeddingProperties.getOptions());
    }

    @Bean
    @ConditionalOnMissingBean
    public FunctionCallbackContext springAiFunctionManager(ApplicationContext context) {
        FunctionCallbackContext manager = new FunctionCallbackContext();
        manager.setApplicationContext(context);
        return manager;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.azure.openai.image", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public AzureOpenAiImageModel azureOpenAiImageClient(OpenAIClient openAIClient, AzureOpenAiImageOptionsProperties imageProperties) {
        return new AzureOpenAiImageModel(openAIClient, imageProperties.getOptions());
    }
}

