/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vertexai.gemini;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.vertexai.VertexAI;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.springframework.ai.autoconfigure.vertexai.gemini.VertexAiGeminiChatProperties;
import org.springframework.ai.autoconfigure.vertexai.gemini.VertexAiGeminiConnectionProperties;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackContext;
import org.springframework.ai.model.function.FunctionCallbackWrapper;
import org.springframework.ai.vertexai.gemini.VertexAiGeminiChatClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@ConditionalOnClass(value={VertexAI.class})
@EnableConfigurationProperties(value={VertexAiGeminiChatProperties.class, VertexAiGeminiConnectionProperties.class})
public class VertexAiGeminiAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public VertexAI vertexAi(VertexAiGeminiConnectionProperties connectionProperties) throws IOException {
        Assert.hasText((String)connectionProperties.getProjectId(), (String)"Vertex AI project-id must be set!");
        Assert.hasText((String)connectionProperties.getLocation(), (String)"Vertex AI location must be set!");
        if (connectionProperties.getCredentialsUri() != null) {
            GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)connectionProperties.getCredentialsUri().getInputStream());
            return new VertexAI(connectionProperties.getProjectId(), connectionProperties.getLocation(), (Credentials)credentials);
        }
        return new VertexAI(connectionProperties.getProjectId(), connectionProperties.getLocation());
    }

    @Bean
    @ConditionalOnMissingBean
    public VertexAiGeminiChatClient vertexAiGeminiChat(VertexAI vertexAi, VertexAiGeminiChatProperties chatProperties, List<FunctionCallback> toolFunctionCallbacks, ApplicationContext context) {
        FunctionCallbackContext functionCallbackContext = this.springAiFunctionManager(context);
        if (!CollectionUtils.isEmpty(toolFunctionCallbacks)) {
            chatProperties.getOptions().getFunctionCallbacks().addAll(toolFunctionCallbacks);
        }
        return new VertexAiGeminiChatClient(vertexAi, chatProperties.getOptions(), functionCallbackContext);
    }

    private FunctionCallbackContext springAiFunctionManager(ApplicationContext context) {
        FunctionCallbackContext manager = new FunctionCallbackContext();
        manager.setSchemaType(FunctionCallbackWrapper.Builder.SchemaType.OPEN_API_SCHEMA);
        manager.setApplicationContext(context);
        return manager;
    }
}

