/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.pinecone;

import org.springframework.ai.autoconfigure.vectorstore.pinecone.PineconeVectorStoreProperties;
import org.springframework.ai.embedding.EmbeddingClient;
import org.springframework.ai.vectorstore.PineconeVectorStore;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={PineconeVectorStore.class, EmbeddingClient.class})
@EnableConfigurationProperties(value={PineconeVectorStoreProperties.class})
public class PineconeVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public PineconeVectorStore vectorStore(EmbeddingClient embeddingClient, PineconeVectorStoreProperties properties) {
        PineconeVectorStore.PineconeVectorStoreConfig config = PineconeVectorStore.PineconeVectorStoreConfig.builder().withApiKey(properties.getApiKey()).withEnvironment(properties.getEnvironment()).withProjectId(properties.getProjectId()).withIndexName(properties.getIndexName()).withNamespace(properties.getNamespace()).withServerSideTimeout(properties.getServerSideTimeout()).build();
        return new PineconeVectorStore(config, embeddingClient);
    }
}

