/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.chroma;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.ai.autoconfigure.vectorstore.chroma.ChromaApiProperties;
import org.springframework.ai.autoconfigure.vectorstore.chroma.ChromaVectorStoreProperties;
import org.springframework.ai.chroma.ChromaApi;
import org.springframework.ai.embedding.EmbeddingClient;
import org.springframework.ai.vectorsore.ChromaVectorStore;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration
@ConditionalOnClass(value={EmbeddingClient.class, RestTemplate.class, ChromaVectorStore.class, ObjectMapper.class})
@EnableConfigurationProperties(value={ChromaApiProperties.class, ChromaVectorStoreProperties.class})
public class ChromaVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean
    @ConditionalOnMissingBean
    public ChromaApi chromaApi(ChromaApiProperties apiProperties, RestTemplate restTemplate) {
        String chromaUrl = String.format("%s:%s", apiProperties.getHost(), apiProperties.getPort());
        ChromaApi chromaApi = new ChromaApi(chromaUrl, restTemplate, new ObjectMapper());
        if (StringUtils.hasText((String)apiProperties.getKeyToken())) {
            chromaApi.withKeyToken(apiProperties.getKeyToken());
        } else if (StringUtils.hasText((String)apiProperties.getUsername()) && StringUtils.hasText((String)apiProperties.getPassword())) {
            chromaApi.withBasicAuthCredentials(apiProperties.getUsername(), apiProperties.getPassword());
        }
        return chromaApi;
    }

    @Bean
    @ConditionalOnMissingBean
    public ChromaVectorStore vectorStore(EmbeddingClient embeddingClient, ChromaApi chromaApi, ChromaVectorStoreProperties storeProperties) {
        return new ChromaVectorStore(embeddingClient, chromaApi, storeProperties.getCollectionName());
    }
}

