/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.stabilityai;

import org.springframework.ai.autoconfigure.stabilityai.StabilityAiConnectionProperties;
import org.springframework.ai.autoconfigure.stabilityai.StabilityAiImageProperties;
import org.springframework.ai.stabilityai.StabilityAiImageClient;
import org.springframework.ai.stabilityai.api.StabilityAiApi;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={RestClientAutoConfiguration.class})
@ConditionalOnClass(value={StabilityAiApi.class})
@EnableConfigurationProperties(value={StabilityAiConnectionProperties.class, StabilityAiImageProperties.class})
public class StabilityAiImageAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public StabilityAiApi stabilityAiApi(StabilityAiConnectionProperties commonProperties, StabilityAiImageProperties imageProperties) {
        String apiKey = StringUtils.hasText((String)imageProperties.getApiKey()) ? imageProperties.getApiKey() : commonProperties.getApiKey();
        String baseUrl = StringUtils.hasText((String)imageProperties.getBaseUrl()) ? imageProperties.getBaseUrl() : commonProperties.getBaseUrl();
        Assert.hasText((String)apiKey, (String)"StabilityAI API key must be set");
        Assert.hasText((String)baseUrl, (String)"StabilityAI base URL must be set");
        return new StabilityAiApi(apiKey, imageProperties.getOptions().getModel(), baseUrl);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.stabilityai.image", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public StabilityAiImageClient stabilityAiImageClient(StabilityAiApi stabilityAiApi, StabilityAiImageProperties stabilityAiImageProperties) {
        return new StabilityAiImageClient(stabilityAiApi, stabilityAiImageProperties.getOptions());
    }
}

