/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.retry;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.retry.NonTransientAiException;
import org.springframework.ai.retry.TransientAiException;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.StreamUtils;
import org.springframework.web.client.ResponseErrorHandler;

public abstract class RetryUtils {
    public static final ResponseErrorHandler DEFAULT_RESPONSE_ERROR_HANDLER = new ResponseErrorHandler(){

        public boolean hasError(@NonNull ClientHttpResponse response) throws IOException {
            return response.getStatusCode().isError();
        }

        public void handleError(@NonNull ClientHttpResponse response) throws IOException {
            if (response.getStatusCode().isError()) {
                String error = StreamUtils.copyToString((InputStream)response.getBody(), (Charset)StandardCharsets.UTF_8);
                String message = String.format("%s - %s", response.getStatusCode().value(), error);
                if (response.getStatusCode().is4xxClientError()) {
                    throw new NonTransientAiException(message);
                }
                throw new TransientAiException(message);
            }
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(RetryUtils.class);
    public static final RetryTemplate DEFAULT_RETRY_TEMPLATE = RetryTemplate.builder().maxAttempts(10).retryOn(TransientAiException.class).exponentialBackoff(Duration.ofMillis(2000L), 5.0, Duration.ofMillis(180000L)).withListener(new RetryListener(){

        public <T, E extends Throwable> void onError(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
            logger.warn("Retry error. Retry count:" + context.getRetryCount(), throwable);
        }
    }).build();
    public static final RetryTemplate SHORT_RETRY_TEMPLATE = RetryTemplate.builder().maxAttempts(10).retryOn(TransientAiException.class).fixedBackoff(Duration.ofMillis(100L)).withListener(new RetryListener(){

        public <T, E extends Throwable> void onError(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
            logger.warn("Retry error. Retry count:" + context.getRetryCount());
        }
    }).build();
}

