/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.qdrant;

import io.qdrant.client.PointIdFactory;
import io.qdrant.client.QdrantClient;
import io.qdrant.client.ValueFactory;
import io.qdrant.client.VectorsFactory;
import io.qdrant.client.WithPayloadSelectorFactory;
import io.qdrant.client.grpc.Collections;
import io.qdrant.client.grpc.JsonWithInt;
import io.qdrant.client.grpc.Points;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.DocumentMetadata;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.model.EmbeddingUtils;
import org.springframework.ai.observation.conventions.VectorStoreProvider;
import org.springframework.ai.vectorstore.AbstractVectorStoreBuilder;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.observation.AbstractObservationVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationContext;
import org.springframework.ai.vectorstore.qdrant.QdrantFilterExpressionConverter;
import org.springframework.ai.vectorstore.qdrant.QdrantObjectFactory;
import org.springframework.ai.vectorstore.qdrant.QdrantValueFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class QdrantVectorStore
extends AbstractObservationVectorStore
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(QdrantVectorStore.class);
    public static final String DEFAULT_COLLECTION_NAME = "vector_store";
    public static final String DEFAULT_CONTENT_FIELD_NAME = "doc_content";
    private final QdrantClient qdrantClient;
    private final String collectionName;
    private final String contentFieldName;
    private final QdrantFilterExpressionConverter filterExpressionConverter = new QdrantFilterExpressionConverter();
    private final boolean initializeSchema;

    protected QdrantVectorStore(Builder builder) {
        super((AbstractVectorStoreBuilder)builder);
        Assert.notNull((Object)builder.qdrantClient, (String)"QdrantClient must not be null");
        this.qdrantClient = builder.qdrantClient;
        this.collectionName = builder.collectionName;
        this.initializeSchema = builder.initializeSchema;
        this.contentFieldName = builder.contentFieldName;
    }

    public static Builder builder(QdrantClient qdrantClient, EmbeddingModel embeddingModel) {
        return new Builder(qdrantClient, embeddingModel);
    }

    public void doAdd(List<Document> documents) {
        try {
            List embeddings = this.embeddingModel.embed(documents, EmbeddingOptions.builder().build(), this.batchingStrategy);
            List<Points.PointStruct> points = documents.stream().map(document -> Points.PointStruct.newBuilder().setId(PointIdFactory.id((UUID)UUID.fromString(document.getId()))).setVectors(VectorsFactory.vectors((float[])((float[])embeddings.get(documents.indexOf(document))))).putAllPayload(this.toPayload((Document)document)).build()).toList();
            this.qdrantClient.upsertAsync(this.collectionName, points).get();
        }
        catch (IllegalArgumentException | InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void doDelete(List<String> documentIds) {
        try {
            List<Points.PointId> ids = documentIds.stream().map(id -> PointIdFactory.id((UUID)UUID.fromString(id))).toList();
            this.qdrantClient.deleteAsync(this.collectionName, ids).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void doDelete(Filter.Expression filterExpression) {
        Assert.notNull((Object)filterExpression, (String)"Filter expression must not be null");
        try {
            Points.Filter filter = this.filterExpressionConverter.convertExpression(filterExpression);
            Points.UpdateResult response = (Points.UpdateResult)this.qdrantClient.deleteAsync(this.collectionName, filter).get();
            if (response.getStatus() != Points.UpdateStatus.Completed) {
                throw new IllegalStateException("Failed to delete documents by filter: " + String.valueOf(response.getStatus()));
            }
            logger.debug("Deleted documents matching filter expression");
        }
        catch (Exception e) {
            logger.error("Failed to delete documents by filter: {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException("Failed to delete documents by filter", e);
        }
    }

    public List<Document> doSimilaritySearch(SearchRequest request) {
        try {
            Points.Filter filter = request.getFilterExpression() != null ? this.filterExpressionConverter.convertExpression(request.getFilterExpression()) : Points.Filter.getDefaultInstance();
            float[] queryEmbedding = this.embeddingModel.embed(request.getQuery());
            Points.SearchPoints searchPoints = Points.SearchPoints.newBuilder().setCollectionName(this.collectionName).setLimit((long)request.getTopK()).setWithPayload(WithPayloadSelectorFactory.enable((boolean)true)).addAllVector((Iterable)EmbeddingUtils.toList((float[])queryEmbedding)).setFilter(filter).setScoreThreshold((float)request.getSimilarityThreshold()).build();
            List queryResponse = (List)this.qdrantClient.searchAsync(searchPoints).get();
            return queryResponse.stream().map(this::toDocument).toList();
        }
        catch (IllegalArgumentException | InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private Document toDocument(Points.ScoredPoint point) {
        try {
            String id = point.getId().getUuid();
            Map<String, ? super Object> metadata = QdrantObjectFactory.toObjectMap(point.getPayloadMap());
            metadata.put(DocumentMetadata.DISTANCE.value(), Float.valueOf(1.0f - point.getScore()));
            String content = (String)metadata.remove(this.contentFieldName);
            return Document.builder().id(id).text(content).metadata(metadata).score(Double.valueOf(point.getScore())).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, JsonWithInt.Value> toPayload(Document document) {
        try {
            Map<String, JsonWithInt.Value> payload = QdrantValueFactory.toValueMap(document.getMetadata());
            payload.put(this.contentFieldName, ValueFactory.value((String)Objects.requireNonNullElse(document.getText(), "")));
            return payload;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.initializeSchema) {
            return;
        }
        if (!this.isCollectionExists()) {
            Collections.VectorParams vectorParams = Collections.VectorParams.newBuilder().setDistance(Collections.Distance.Cosine).setSize((long)this.embeddingModel.dimensions()).build();
            this.qdrantClient.createCollectionAsync(this.collectionName, vectorParams).get();
        }
    }

    private boolean isCollectionExists() {
        try {
            return ((List)this.qdrantClient.listCollectionsAsync().get()).stream().anyMatch(c -> c.equals(this.collectionName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public VectorStoreObservationContext.Builder createObservationContextBuilder(String operationName) {
        return VectorStoreObservationContext.builder((String)VectorStoreProvider.QDRANT.value(), (String)operationName).dimensions(Integer.valueOf(this.embeddingModel.dimensions())).collectionName(this.collectionName);
    }

    public <T> Optional<T> getNativeClient() {
        QdrantClient client = this.qdrantClient;
        return Optional.of(client);
    }

    public static class Builder
    extends AbstractVectorStoreBuilder<Builder> {
        private final QdrantClient qdrantClient;
        private String collectionName = "vector_store";
        private String contentFieldName = "doc_content";
        private boolean initializeSchema = false;

        private Builder(QdrantClient qdrantClient, EmbeddingModel embeddingModel) {
            super(embeddingModel);
            Assert.notNull((Object)qdrantClient, (String)"QdrantClient must not be null");
            this.qdrantClient = qdrantClient;
        }

        public Builder collectionName(String collectionName) {
            Assert.hasText((String)collectionName, (String)"collectionName must not be empty");
            this.collectionName = collectionName;
            return this;
        }

        public Builder contentFieldName(String contentFieldName) {
            Assert.hasText((String)contentFieldName, (String)"contentFieldName must not be empty");
            this.contentFieldName = contentFieldName;
            return this;
        }

        public Builder initializeSchema(boolean initializeSchema) {
            this.initializeSchema = initializeSchema;
            return this;
        }

        public QdrantVectorStore build() {
            return new QdrantVectorStore(this);
        }
    }
}

