/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.qdrant;

import io.qdrant.client.ValueFactory;
import io.qdrant.client.grpc.JsonWithInt;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

final class QdrantValueFactory {
    private QdrantValueFactory() {
    }

    public static Map<String, JsonWithInt.Value> toValueMap(Map<String, ? extends @Nullable Object> inputMap) {
        Assert.notNull(inputMap, (String)"Input map must not be null");
        return inputMap.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> QdrantValueFactory.value(e.getValue())));
    }

    private static JsonWithInt.Value value(@Nullable Object value) {
        if (value == null) {
            return ValueFactory.nullValue();
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            Object[] objectArray = new Object[length];
            for (int i = 0; i < length; ++i) {
                objectArray[i] = Array.get(value, i);
            }
            return QdrantValueFactory.value(objectArray);
        }
        if (value instanceof Map) {
            return QdrantValueFactory.value((Map)value);
        }
        if (value instanceof List) {
            return QdrantValueFactory.value((List)value);
        }
        return switch (value.getClass().getSimpleName()) {
            case "String" -> ValueFactory.value((String)((String)value));
            case "Integer" -> ValueFactory.value((long)((Integer)value).intValue());
            case "Long" -> ValueFactory.value((String)String.valueOf(value));
            case "Double" -> ValueFactory.value((double)((Double)value));
            case "Float" -> ValueFactory.value((double)((Float)value).floatValue());
            case "Boolean" -> ValueFactory.value((boolean)((Boolean)value));
            default -> throw new IllegalArgumentException("Unsupported Qdrant value type: " + String.valueOf(value.getClass()));
        };
    }

    private static JsonWithInt.Value value(List<Object> elements) {
        ArrayList<JsonWithInt.Value> values = new ArrayList<JsonWithInt.Value>(elements.size());
        for (Object element : elements) {
            values.add(QdrantValueFactory.value(element));
        }
        return ValueFactory.list(values);
    }

    private static JsonWithInt.Value value(Object[] elements) {
        ArrayList<JsonWithInt.Value> values = new ArrayList<JsonWithInt.Value>(elements.length);
        for (Object element : elements) {
            values.add(QdrantValueFactory.value(element));
        }
        return ValueFactory.list(values);
    }

    private static JsonWithInt.Value value(Map<String, @Nullable Object> inputMap) {
        JsonWithInt.Struct.Builder structBuilder = JsonWithInt.Struct.newBuilder();
        Map<String, JsonWithInt.Value> map = QdrantValueFactory.toValueMap(inputMap);
        structBuilder.putAllFields(map);
        return JsonWithInt.Value.newBuilder().setStructValue(structBuilder).build();
    }
}

