/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.qdrant;

import io.qdrant.client.grpc.JsonWithInt;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

final class QdrantObjectFactory {
    private static final Log logger = LogFactory.getLog(QdrantObjectFactory.class);

    private QdrantObjectFactory() {
    }

    public static Map<String, Object> toObjectMap(Map<String, JsonWithInt.Value> payload) {
        Assert.notNull(payload, (String)"Payload map must not be null");
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, JsonWithInt.Value> entry : payload.entrySet()) {
            map.put(entry.getKey(), QdrantObjectFactory.object(entry.getValue()));
        }
        return map;
    }

    private static Object object(JsonWithInt.ListValue listValue) {
        return listValue.getValuesList().stream().map(QdrantObjectFactory::object).collect(Collectors.toList());
    }

    private static Object object(JsonWithInt.Value value) {
        return switch (value.getKindCase()) {
            case JsonWithInt.Value.KindCase.INTEGER_VALUE -> value.getIntegerValue();
            case JsonWithInt.Value.KindCase.STRING_VALUE -> value.getStringValue();
            case JsonWithInt.Value.KindCase.DOUBLE_VALUE -> value.getDoubleValue();
            case JsonWithInt.Value.KindCase.BOOL_VALUE -> value.getBoolValue();
            case JsonWithInt.Value.KindCase.LIST_VALUE -> QdrantObjectFactory.object(value.getListValue());
            case JsonWithInt.Value.KindCase.STRUCT_VALUE -> QdrantObjectFactory.toObjectMap(value.getStructValue().getFieldsMap());
            case JsonWithInt.Value.KindCase.NULL_VALUE -> null;
            default -> {
                logger.warn((Object)("Unsupported value type: " + String.valueOf(value.getKindCase())));
                yield null;
            }
        };
    }
}

