/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.qdrant;

import io.qdrant.client.grpc.JsonWithInt;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

final class QdrantObjectFactory {
    private static final Log logger = LogFactory.getLog(QdrantObjectFactory.class);

    private QdrantObjectFactory() {
    }

    public static Map<String, Object> toObjectMap(Map<String, JsonWithInt.Value> payload) {
        Assert.notNull(payload, (String)"Payload map must not be null");
        return payload.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> QdrantObjectFactory.object((JsonWithInt.Value)e.getValue())));
    }

    private static Object object(JsonWithInt.ListValue listValue) {
        return listValue.getValuesList().stream().map(QdrantObjectFactory::object).collect(Collectors.toList());
    }

    private static Object object(JsonWithInt.Value value) {
        switch (value.getKindCase()) {
            case INTEGER_VALUE: {
                return value.getIntegerValue();
            }
            case STRING_VALUE: {
                return value.getStringValue();
            }
            case DOUBLE_VALUE: {
                return value.getDoubleValue();
            }
            case BOOL_VALUE: {
                return value.getBoolValue();
            }
            case LIST_VALUE: {
                return QdrantObjectFactory.object(value.getListValue());
            }
            case STRUCT_VALUE: {
                return QdrantObjectFactory.toObjectMap(value.getStructValue().getFieldsMap());
            }
            case NULL_VALUE: {
                return null;
            }
        }
        logger.warn((Object)("Unsupported value type: " + String.valueOf(value.getKindCase())));
        return null;
    }
}

